{
	BIN2CRY.PAS
	Encrypt Binaries
	----------------------------------------------------------------------
	Copyright (c) 1994-98 by Florian Painke (f.painke@gmx.de).

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful, but
	WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to
		Free Software Foundation, Inc.
		59 Temple Place - Suite 330
		Boston, MA  02111-1307, USA
	or visit the GNU Homepage at http://www.gnu.org/.
}

program BIN2CRY;

uses
  DOS, CRT;

type
  PArray = ^TArray;
  TArray = array[0..511] of byte;

var
  SrcFile, DstFile :File;
  SrcName, DstName :string;
  Buffer           :PArray;
  S1, S2, S3       :integer;
  RndIdx, Counter  :longint;

begin
  if ParamCount = 0 then begin
    writeln('Syntax: BIN2CRY <file>');
    halt(1)
  end;
  SrcName := ParamStr(1);
  S1 :=Pos('.', Copy(SrcName, Length(SrcName) - 3, 4));
  if S1 = 0 then begin
    DstName := SrcName + '.CRY';
    SrcName := SrcName + '.BIN';
  end else begin
    DstName := Copy(SrcName, 1, Length(SrcName) + S1 - 5) + '.CRY';
  end;
  if ParamCount > 1 then begin
    val(ParamStr(2), RandSeed, S1);
    if S1 <> 0 then Randomize
  end else Randomize;
  RndIdx :=RandSeed;
  assign(DstFile, DstName);
  rewrite(DstFile, 1);
  if IOResult = 0 then begin
    assign(SrcFile, SrcName);
    reset(SrcFile, 1);
    if IOResult = 0 then begin
      S1 :=FileSize(SrcFile);
      if S1 > 0 then begin
        if S1 <= MaxAvail then begin
          GetMem(Buffer, S1);
          BlockRead(SrcFile, Buffer^, S1, S2);
          for Counter :=0 to S2 - 1 do Buffer^[Counter] := Buffer^[Counter] xor Random(256);
          BlockWrite(DstFile, Buffer^, S2, S3);
          if (S3 <> S2) then writeln('Failed to write binfile.');
          FreeMem(Buffer, S1)
        end else begin
          S1 := MaxAvail;
          GetMem(Buffer, S1);
          repeat
            BlockRead(SrcFile, Buffer^, S1, S2);
            for Counter :=0 to S2 - 1 do Buffer^[Counter] := Buffer^[Counter] xor Random(256);
            BlockWrite(DstFile, Buffer^, S2, S3);
            if (S3 <> S2) then writeln('Failed to write binfile.');
          until EOF(SrcFile) or (S3 <> S2);
          FreeMem(Buffer, S1)
        end;
        close(SrcFile)
      end else writeln('Not a valid exefile');
    end else writeln('Failed to open exefile');
    writeln(FileSize(DstFile):10, ' bytes crypted.');
    BlockWrite(DstFile, RndIdx, sizeof(RndIdx), S1);
    close(DstFile)
  end else writeln('Failed to create binfile.')
end.
