{
	DISKCTRL.PAS
	Low Level Fixed Disk Access
	----------------------------------------------------------------------
	Copyright (c) 1994-98 by Florian Painke (f.painke@gmx.de).

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful, but
	WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to
		Free Software Foundation, Inc.
		59 Temple Place - Suite 330
		Boston, MA  02111-1307, USA
	or visit the GNU Homepage at http://www.gnu.org/.
}

Unit DiskCtrl;

{Code-Erzeugung}
{$IFDEF DEBUG}
  {$I HDEBUG.INC}
{$ELSE}
  {$I HNDEBUG.INC}
{$ENDIF}


interface

const
  TimeoutInactivate = 0;
  TimeoutReset		= 1;
  TimeoutIgnore 	= 2;

  ErrorDriveFormatFailed  = $f0;
  ErrorDriveFormatUnknown = $f1;
  ErrorDriveDeInit		  = $ff;

type
  {Initialisation}
  TInit = (INITNONE, INITREAD, INITWRITE, INITREADWRITE);
  {Positions Record fr BIOS-Funktionen}
  TPos = record
	Head	 :byte; 				   {Schreib-/Lesekopf}
	SecCyl	 :word; 				   {Sektor/Cylinder im BIOS-Format}
  end;
  {Bios Parameter Block}
  PBPB = ^TBPB;
  TBPB = record
	SectSize :word; 				   {Sektorgre in Byte}
	ClusSize :byte; 				   {Clustergre in Sektoren}
	ResvSect :word; 				   {Reservierte Sektoren f. BootStrap}
	FATCnt	 :byte; 				   {Anzahl der FATs}
	RootEntr :word; 				   {Gre des Wurzelverzeichnisses}
	VoluSize :word; 				   {Volumegre in Sektoren}
	Media	 :byte; 				   {MediaDescriptor}
	FATSize  :word; 				   {Gre der FAT}
  end;
  {Eintrag in die Partitionstabelle}
  PPartEntr = ^TPartEntr;
  TPartEntr = record
	PartStat :byte; 				   {Status: $80 Aktiv, $00 inaktiv}
	StartPos :TPos; 				   {Startposition der Partition}
	PartType :byte; 				   {Partitionstyp ($05=Erweitert)}
	EndPos	 :TPos; 				   {Endposition}
	Distance :longint;				   {Entfernung zur Partitionstabelle}
	PartSize :longint;				   {Gre der Partition in Sektoren}
  end;
  {Eintrag in das BootManager Menu}
  PInfoEntr = ^TInfoEntr;
  TInfoEntr = record
	BootDriv :byte; 				   {Festplatte}
	BootPos  :TPos; 				   {Position des Bootsektors}
	PartLDrv :byte; 				   {Logisches Laufwerk}
	PartType :byte; 				   {Partitionstyp}
	PartEntr :byte; 				   {Eintag in der Partitionstabelle}
	PartSize :word; 				   {Gre der Partition in MB}
	Distance :longint;				   {Distanz der Partition}
	PartName :array[0..16] of char;    {Name der Partition (16 Chars + #0)}
	EntrMark :word; 				   {Markierung: $0/$AA55 un-/benutzt}
  end;
  {Eintrag in die Passwortliste}
  PPWDEntry = ^TPWDEntry;
  TPWDEntry = record
	Protection	:byte;
	Password	:array[0..16] of char;
  end;
  {Puffer fr den Partitionssektor}
  PPartSect =^TPartSect;
  TPartSect = record
	PartCode :array[0..445] of byte;   {Partitions-Code}
	PartEntr :array[0..3] of TPartEntr;{Eintrge in die Partitionstabelle}
	PartMark :word; 				   {Markierung: $AA55 Partitionssektor}
  end;
  {Puffer fr den Bootsektor}
  PBootSect = ^TBootSect;
  TBootSect = record
	BootJump :array[0..2] of byte;	   {Jump-Befehl in die BootStrap}
	PartName :array[0..7] of byte;	   {Partitionsname}
	PartBlck :TBPB; 				   {BIOS Parameter Block}
	CylnSize :word; 				   {Cylindergre in Sektoren}
	Heads	 :word; 				   {Anzahl der Schreib-/Lesekpfe}
	Distance :longint;				   {Entfernung vom Partitionssektor}
	Unused	 :array[0..10] of byte;
	PartLabl :array[0..10] of byte;    {Label}
	PartSyst :array[0..7] of byte;	   {Systemkennung}
	BootCode :array[0..447] of byte;   {BootStrap}
	PartMark :word;
  end;
  {Puffer fr den BootManager Menusektor}
  PInfoSect = ^TInfoSect;
  TInfoSect = record
	InfoEntr  :array[0..7] of TInfoEntr;		{Eintrge in die Menutabelle}
	MasterPWD :TPWDEntry;			   {Master Pawort}
	FloppyPWD :TPWDEntry;			   {Floppy Pawort}
	PWDEntr   :array[0..7] of TPWDEntry;		{Partitionspawrter}
	Unused	  :array[0..54] of byte;
	BootLast  :byte;				   {Zuletzt gewhlten Eintrag booten}
	LastEntry :byte;				   {Zuletzt gewhlter Eintrag}
	BlindSupp :byte;				   {BlindSupport}
	TimeHndl  :byte;				   {Timeout Handling
										0: inaktivieren,
										1: zurcksetzen,
										2: ignorieren}
	ClearScrn :byte;				   {Bildschirm lschen}
	VerMark   :word;				   {Versionsnummer Markierung}
	VerInfo   :word;				   {Version}
	MENRndIdx :longint; 			   {Random Seed}
	MENChkSum :longint; 			   {Checksumme}
	WaitTime  :word;				   {Timeout Zeit}
	InfoMark  :word;				   {Markierung}
  end;
  {Sektorpuffer}
  PBuffer = ^TBuffer;
  TBuffer = array[0..511] of byte;
  {Puffer fr den Partitionszylinder (BootManager)}
  PPartCyln = ^TPartCyln;
  TPartCyln = record
	PartSect :TPartSect;			   {Partitionssektor}
	CodeSect :array[0..13] of TBuffer; {14 Codesektoren}
	InfoSect :TInfoSect;			   {Menusektor}
	OldMBR	 :TPartSect;			   {Kopie des Originalen MBR}
  end;

procedure SetPos(Head :byte; Cylinder, Sector :word; var VPos :TPos);
procedure GetPos(var Head :byte; var Cylinder, Sector :word; VPos :TPos);
procedure SectCopy(var Dest; var Source; Start, Len :integer);
function GetNumberOfDrives :byte;
{function ResetDrive(Drive :byte) :byte;}
function GetDriveStatus(Drive :byte) :byte;
function InitReadWriteSectors(Drive :byte; RWInit :TInit) :word;
function DeInitReadWriteSectors(Drive :byte) :word;
function ReadSectors(Drive :byte; VPos :TPos; Count :byte; Buffer :pointer) :byte;
function WriteSectors(Drive :byte; VPos :TPos; Count :byte; Buffer :pointer) :byte;
function VerifySectors(Drive :byte; VPos :TPos; Count :byte; Buffer :pointer) :byte;
function FormatCylinder(Drive :byte; VPos :TPos) :byte;
function GetDriveFormat(Drive :byte; var VPos :TPos; var Misc :byte) :byte;
{function RecalibrateDrive(Drive :byte) :byte;}

implementation

uses
  DOS, Misc;

type
  TEmul = (EMULNONE, EMULWIN32, EMULOS2, EMULLINUX, EMULMAC);

const
  MaxErrors = 3;

var
  Regs :Registers;
  Init :TInit;
  Emul :TEmul;

procedure SetPos;
begin
  VPos.Head :=Head;
  VPos.SecCyl :=(lo(Cylinder) shl 8)  + ((hi(Cylinder) and 3) shl 6) + (lo(Sector) and 63)
end;

procedure GetPos;
begin
  Head :=VPos.Head;
  Sector :=lo(VPos.SecCyl) and 63;
  Cylinder :=(hi(VPos.SecCyl)) + ((lo(VPos.SecCyl) and 192) shl 2)
end;

procedure SectCopy;
var
  Cnt		:integer;
  SrcBuffer :PBuffer;
  DstBuffer :PBuffer;
begin
  SrcBuffer :=PBuffer(@Source);
  DstBuffer :=PBuffer(@Dest);
  for Cnt :=Start to Start + Len - 1 do
	DstBuffer^[Cnt] :=SrcBuffer^[Cnt];
end;

function GetNumberOfDrives;
var
  VPos :TPos;
  Drvs :byte;
begin
  GetDriveFormat($80, VPos, Drvs);
  GetNumberOfDrives :=Drvs;
end;

function ResetDrive(Drive :byte) :byte;
begin
  Regs.AH :=$00;
  Regs.DL :=Drive;
  intr($13, Regs);
  if (Regs.Flags and 1) = 1 then
	ResetDrive :=Regs.AH
  else
	ResetDrive :=0;
end;

function GetDriveStatus;
begin
  Regs.AH :=$01;
  Regs.DL :=Drive;
  intr($13, Regs);
  if (Regs.Flags and 1) = 1 then
	GetDriveStatus :=Regs.AH
  else
	GetDriveStatus :=0;
end;

function InitReadWriteSectors(Drive :byte; RWInit :TInit) :word;
begin
  Init :=RWInit;
  if (Emul = EMULWIN32) then begin
	Regs.AX :=$440D;
	Regs.BH :=1;
	Regs.BL :=Drive;
	Regs.CX :=$084B;
	if ((RWInit = INITWRITE) or (RWInit = INITREADWRITE)) then
	  Regs.DX :=1
	else
	  Regs.DX :=0;
	intr($21, Regs);
	if ((Regs.flags and fCarry) <> 0) then begin
	  InitReadWriteSectors :=Regs.AX;
	  Init :=INITNONE;
	end else
	  InitReadWriteSectors :=0;
  end else
	InitReadWriteSectors :=0;
end;

function DeInitReadWriteSectors(Drive :byte) :word;
begin
  Init :=INITNONE;
  if (Emul = EMULWIN32) then begin
	Regs.AX :=$440D;
	Regs.BL :=Drive;
	Regs.CX :=$086B;
	intr($21, Regs);
	if ((Regs.flags and fCarry) <> 0) then
	  DeInitReadWriteSectors :=Regs.AX
	else
	  DeInitReadWriteSectors :=0;
  end else
	DeInitReadWriteSectors :=0;
end;

function ReadSectors;
var
  ErrCnt :integer;
  Result :integer;
begin
  if ((Init = INITREAD) or (Init = INITREADWRITE)) then begin
	ErrCnt :=MaxErrors;
	repeat
	  Regs.AH :=$02;
	  Regs.DL :=Drive;
	  Regs.DH :=VPos.Head;
	  Regs.CX :=VPos.SecCyl;
	  Regs.AL :=Count;
	  Regs.ES :=seg(Buffer^);
	  Regs.BX :=ofs(Buffer^);
	  intr($13, Regs);
	  if (Regs.Flags and 1) = 1 then begin
		Result :=Regs.AH;
		ResetDrive(Drive);
	  end else
		Result :=0;
	  dec(ErrCnt);
	until ((ErrCnt = 0) or (Result = 0));
	ReadSectors := Result;
  end else
	ReadSectors :=ErrorDriveDeInit;
end;

function WriteSectors;
var
  ErrCnt :integer;
  Result :integer;
begin
  if ((Init = INITWRITE) or (Init = INITREADWRITE)) then begin
	ErrCnt :=MaxErrors;
	repeat
	  Regs.AH :=$03;
	  Regs.DL :=Drive;
	  Regs.DH :=VPos.Head;
	  Regs.CX :=VPos.SecCyl;
	  Regs.AL :=Count;
	  Regs.ES :=seg(Buffer^);
	  Regs.BX :=ofs(Buffer^);
	  intr($13, Regs);
	  if (Regs.Flags and 1) = 1 then begin
		Result :=Regs.AH;
		ResetDrive(Drive);
	  end else
		Result :=0;
	  dec(ErrCnt);
	until ((ErrCnt = 0) or (Result = 0));
	WriteSectors := Result;
  end else
	WriteSectors :=ErrorDriveDeInit;
end;

function VerifySectors;
var
  ErrCnt :integer;
  Result :integer;
begin
  if ((Init = INITREAD) or (Init = INITREADWRITE)) then begin
	ErrCnt :=MaxErrors;
	repeat
	  Regs.AH :=$04;
	  Regs.DL :=Drive;
	  Regs.DH :=VPos.Head;
	  Regs.CX :=VPos.SecCyl;
	  Regs.AL :=Count;
	  Regs.ES :=seg(Buffer^);
	  Regs.BX :=ofs(Buffer^);
	  intr($13, Regs);
	  if (Regs.Flags and 1) = 1 then begin
		Result :=Regs.AH;
		ResetDrive(Drive);
	  end else
		Result :=0;
	  dec(ErrCnt);
	until ((ErrCnt = 0) or (Result = 0));
	VerifySectors := Result;
  end else
	VerifySectors :=ErrorDriveDeInit;
end;

function FormatCylinder;
var
  Buffer		   :TBuffer;
  Size			   :TPos;
  Dummy, Head	   :byte;
  Sector, Cylinder :word;
  ErrCnt		   :integer;
  Result		   :integer;
begin
  if ((Init = INITWRITE) or (Init = INITREADWRITE)) then begin
	FormatCylinder :=0;
	if GetDriveFormat(Drive, Size, Dummy) = 0 then begin
	  GetPos(Head, Sector, Cylinder, Size);
	  FillChar(Buffer, SizeOf(Buffer), 0);
	  for Dummy :=1 to Sector do
		Buffer[Dummy * 2 - 1] :=Dummy;
	  ErrCnt :=MaxErrors;
	  repeat
		Regs.AH :=$05;
		Regs.DL :=Drive;
		Regs.DH :=VPos.Head;
		Regs.CX :=VPos.SecCyl;
		Regs.AL :=Sector;
		Regs.ES :=seg(Buffer);
		Regs.BX :=ofs(Buffer);
		intr($13, Regs);
		if (Regs.Flags and 1) = 1 then begin
		  Result :=Regs.AH;
		  ResetDrive(Drive);
		end else begin
		  Result :=0;
		  for Dummy :=1 to Sector do
			if Buffer[Dummy * 2 - 2] <> 0 then
			  Result :=ErrorDriveFormatFailed;
		end;
		dec(ErrCnt);
	  until ((ErrCnt = 0) or (Result = 0));
	  FormatCylinder :=Result;
	end else
	  FormatCylinder :=ErrorDriveFormatUnknown;
  end else
	FormatCylinder :=ErrorDriveDeInit;
end;

function GetDriveFormat;
begin
  Regs.AH :=$08;
  Regs.DL :=Drive;
  intr($13, Regs);
  if (Regs.Flags and 1) = 1 then begin
	GetDriveFormat :=Regs.AH;
	VPos.Head :=0; VPos.SecCyl :=0; Misc :=0
  end else begin
	GetDriveFormat :=0;
	VPos.Head :=Regs.DH; VPos.SecCyl :=Regs.CX;
	if Drive < $80 then
	  Misc :=Regs.BL
	else
	  Misc :=Regs.DL
  end
end;

{function RecalibrateDrive;
begin
  Regs.AH :=$11;
  Regs.DL :=Drive;
  intr($13, Regs);
  if (Regs.Flags and 1) = 1 then
	RecalibrateDrive :=Regs.AH
  else
	RecalibrateDrive :=0;
end;}

var
  DosVer, WinVer :word;

begin
  Init :=INITNONE;

  DosVer :=GetDosVer;
  WinVer :=GetWinVer;
  if (WinVer = 0) then
	if (hi(DosVer) <> 20) then
	  Emul :=EMULNONE
	else
	  Emul :=EMULOS2
  else if (hi(WinVer) < 4) then
	Emul :=EMULNONE
  else
	Emul :=EMULWIN32;
end.
