{
	XBOOTM.INC
	Bootmanager Configuration and Installation Functions and Procedures
	----------------------------------------------------------------------
	Copyright (c) 1994-98 by Florian Painke (f.painke@gmx.de).

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful, but
	WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to
		Free Software Foundation, Inc.
		59 Temple Place - Suite 330
		Boston, MA  02111-1307, USA
	or visit the GNU Homepage at http://www.gnu.org/.
}

{Checksumme ermitteln}
function CalcCheck(var Source; Cnt :integer) :longint;
var
  iCnt	 :integer;
  iChk	 :longint;
  Buffer :PBuffer;
begin
  Buffer :=PBuffer(@Source);
  iChk :=0;
  for iCnt :=1 to Cnt do begin
	{$IFDEF DEBUG}
	  {$R-}
	  {$Q-}
	{$ENDIF}
	iChk :=iChk + (longint(Buffer^[iCnt-1]) * longint(iCnt));
	if (odd(iChk)) then
	  iChk :=iChk xor BMCheckOddMask
	else
	  iChk :=iChk xor BMCheckEvenMask;
	{$IFDEF DEBUG}
	  {$R+}
	  {$Q+}
	{$ENDIF}
  end;

  CalcCheck :=iChk
end;

{BootManager crypten}
procedure ProtectBM(var Source; Size :integer; Seed: longint);
var
  Cnt	 :integer;
  Buffer :PBuffer;
begin
  Buffer :=PBuffer(@Source);
  RandSeed :=Seed;
  for Cnt :=0 to Size - 1 do begin
	{$IFDEF DEBUG}
	  {$R-}
	  {$Q-}
	{$ENDIF}
	Buffer^[Cnt] := Buffer^[Cnt] xor Random(256);
	{$IFDEF DEBUG}
	  {$R+}
	  {$Q+}
	{$ENDIF}
  end;
end;


{BootManager Installation}
function InstallBM :boolean;
var
  PartCyln	  :PPartCyln;
  Res		  :integer;
  Res2		  :integer;
  Cnt		  :word;
  VPos		  :TPos;
  Buffer	  :PBuffer;
  BinFile	  :File;
begin
  InstallBM :=FALSE;
  PartCyln :=new(PPartCyln);

  SetPos(0, 0, 1, VPos);

  InitReadWriteSectors(FirstDrive, INITREAD);
  Res :=ReadSectors(FirstDrive, VPos, PartCylnSectorCount, PartCyln);
  DeInitReadWriteSectors(FirstDrive);

  if (Res = 0) then begin
	{Do a little Garbage...}
	Buffer :=@PartCyln^.CodeSect[0];
	Randomize;
	{BUG: Seltsame Zeigerfehler. Off by One.}
	{FIX: 8192 -> 8191}
	for Cnt :=0 to 8191 do begin
	  {$IFDEF DEBUG}
		{$R-}
		{$Q-}
	  {$ENDIF}
	  Buffer^[Cnt] :=Random(256);
	  {$IFDEF DEBUG}
		{$R+}
		{$Q+}
	  {$ENDIF}
	end;

	{Ist Der originale MBR berhaupt gltig?}
	if (PartCyln^.PartSect.PartMark = Marker) then begin
	  SectCopy(PartCyln^.OldMBR, PartCyln^.PartSect, 0, 512);
	  FillChar(PartCyln^.PartSect, 440, 0)
	end else
	  FillChar(PartCyln^.PartSect, 512, 0);

	assign(BinFile, XFDISKPath);
	FileMode :=0;
	reset(BinFile, 1);
	if (IOResult = 0) then
	  seek(BinFile, XFDISKSize);
	if (IOResult = 0) then begin
	  BlockRead(BinFile, PartCyln^.PartSect, XMBRSize, Res);
	  if (Res = XMBRSize) then begin
		BlockRead(BinFile, PartCyln^.CodeSect[0], XMENUSize, Res);
		BlockRead(BinFile, PartCyln^.InfoSect.MENRndIdx, 4, Res2);
		close(BinFile);
		if ((Res = XMENUSize) and (Res2 = 4)) then begin
		  {Decrypten, nur MENU.BIN}
		  ProtectBM(PartCyln^.CodeSect[0], XMENUSize, PartCyln^.InfoSect.MENRndIdx);

		  PartCyln^.InfoSect.InfoMark  :=Marker;

		  PartCyln^.PartSect.PartMark  :=Marker;

		  PartCyln^.InfoSect.VerMark   := Marker;
		  PartCyln^.InfoSect.VerInfo   := VerInfo.Prog * 10000 +
										  VerInfo.Major * 100 +
										  VerInfo.Minor;

		  {Reste lschen!!!}
		  FillChar(PartCyln^.InfoSect.InfoEntr[0], MaxEntries * 32, 0);
		  FillChar(PartCyln^.InfoSect.MasterPWD, 180, 0);

		  PartCyln^.InfoSect.WaitTime  :=TimeoutDef;
		  PartCyln^.InfoSect.TimeHndl  :=TimeoutInactivate;
		  PartCyln^.InfoSect.ClearScrn :=0;
		  if (BlindSupp) then
			PartCyln^.InfoSect.BlindSupp :=1
		  else
			PartCyln^.InfoSect.BlindSupp :=0;

		  PartCyln^.InfoSect.MENChkSum :=CalcCheck(PartCyln^.CodeSect[0], XCHKSize);

		  {Encrypten}
		  ProtectBM(PartCyln^.CodeSect[0], XCRYSize, PartCyln^.InfoSect.MENRndIdx);

		  InitReadWriteSectors(FirstDrive, INITWRITE);
		  Res :=WriteSectors(FirstDrive, VPos, PartCylnSectorCount, PartCyln);
		  DeInitReadWriteSectors(FirstDrive);

		  if (Res = 0) then begin
			InstallBM :=TRUE

		  end else
			MessageBox(BOX_WARN_errHDD_HDR,
			  BOX_WARN + BOX_WARN_errHDD_wrtPCyl,
			  ButtonOK or ButtonDefOK)

		end else
		  MessageBox(BOX_WARN_errFile_HDR,
			BOX_WARN + BOX_WARN_errFile_rdBMgr,
			ButtonOK or ButtonDefOK)

	  end else
		MessageBox(BOX_WARN_errFile_HDR,
		  BOX_WARN + BOX_WARN_errFile_rdMBR,
		  ButtonOK or ButtonDefOK)

	end else
	  MessageBox(BOX_WARN_errFile_HDR,
		BOX_WARN + BOX_WARN_errFile_opnXFD,
		ButtonOK or ButtonDefOK)

  end else
	MessageBox(BOX_WARN_errHDD_HDR,
	  BOX_WARN + BOX_WARN_errHDD_rdPCyl,
	  ButtonOK or ButtonDefOK);

  dispose(PartCyln);
  InstallBM :=TRUE;
end;

{BootManager Deinstallation}
function UnInstallBM :boolean;
var
  PartCyln	  :PPartCyln;
  Res		  :integer;
  VPos		  :TPos;
  HDriv 	  :PDriveChain;
  HPart 	  :PPartChain;
begin
  UnInstallBM :=FALSE;
  PartCyln :=new(PPartCyln);
  SetPos(0, 0, 1, VPos);

  InitReadWriteSectors(FirstDrive, INITREAD);
  Res :=ReadSectors(FirstDrive, VPos, PartCylnSectorCount, PartCyln);
  DeInitReadWriteSectors(FirstDrive);

  if (Res = 0) then begin
	{Ist der alte MBR berhaupt gltig?}
	if (PartCyln^.OldMBR.PartMark = Marker) then
	  SectCopy(PartCyln^.PartSect, PartCyln^.OldMBR, 0, 446);
	FillChar(PartCyln^.CodeSect[0], 8192, 0);

	InitReadWriteSectors(FirstDrive, INITWRITE);
	Res :=WriteSectors(FirstDrive, VPos, PartCylnSectorCount, PartCyln);
	DeInitReadWriteSectors(FirstDrive);

	if (Res = 0) then begin
	  UnInstallBM :=TRUE;

	end else
	  MessageBox(BOX_WARN_errHDD_HDR,
		BOX_WARN + BOX_WARN_errHDD_wrtPCyl,
		ButtonOK or ButtonDefOK)

  end else
	MessageBox(BOX_WARN_errHDD_HDR,
	  BOX_WARN + BOX_WARN_errHDD_rdPCyl,
	  ButtonOK or ButtonDefOK);

  dispose(PartCyln);
end;

{BootManager Erneuern}
function UpdateBM :boolean;
var
  PartCyln	  :PPartCyln;
  Res		  :integer;
  Res2		  :integer;
  Cnt		  :word;
  VPos		  :TPos;
  Buffer	  :PBuffer;
  BinFile	  :File;
begin
  UpdateBM :=FALSE;
  PartCyln :=new(PPartCyln);

  SetPos(0, 0, 1, VPos);

  InitReadWriteSectors(FirstDrive, INITREAD);
  Res :=ReadSectors(FirstDrive, VPos, PartCylnSectorCount, PartCyln);
  DeInitReadWriteSectors(FirstDrive);

  if (Res = 0) then begin
	{Decrypten}
	ProtectBM(PartCyln^.CodeSect[0], CryptSize, PartCyln^.InfoSect.MENRndIdx);

	{Ist Der originale MBR berhaupt gltig?}
	if (PartCyln^.PartSect.PartMark = Marker) then
	  FillChar(PartCyln^.PartSect, 440, 0)
	else
	  FillChar(PartCyln^.PartSect, 512, 0);

	assign(BinFile, XFDISKPath);
	FileMode :=0;
	reset(BinFile, 1);
	if (IOResult = 0) then
	  seek(BinFile, XFDISKSize);
	if (IOResult = 0) then begin
	  BlockRead(BinFile, PartCyln^.PartSect, XMBRSize, Res);
	  if (Res = XMBRSize) then begin
		BlockRead(BinFile, PartCyln^.CodeSect[0], XMENUSize, Res);
		BlockRead(BinFile, PartCyln^.InfoSect.MENRndIdx, 4, Res2);
		close(BinFile);
		if ((Res = XMENUSize) and (Res2 = 4)) then begin
		  {Decrypten, nur MENU.BIN}
		  ProtectBM(PartCyln^.CodeSect[0], XMENUSize, PartCyln^.InfoSect.MENRndIdx);

		  {Passwrter erst ab Version 1.05}
		  if ((PartCyln^.InfoSect.VerMark <> Marker) or
			  (PartCyln^.InfoSect.VerInfo < BMVersionExtension1)) then
			FillChar(PartCyln^.InfoSect.MasterPWD, 180, 0);

		  PartCyln^.InfoSect.InfoMark  :=Marker;

		  PartCyln^.PartSect.PartMark  :=Marker;

		  PartCyln^.InfoSect.VerMark   := Marker;
		  PartCyln^.InfoSect.VerInfo   := VerInfo.Prog * 10000 +
										  VerInfo.Major * 100 +
										  VerInfo.Minor;

		  PartCyln^.InfoSect.WaitTime  :=TimeoutDef;
		  PartCyln^.InfoSect.TimeHndl  :=TimeoutInactivate;
		  PartCyln^.InfoSect.ClearScrn :=0;
		  if (BlindSupp) then
			PartCyln^.InfoSect.BlindSupp :=1
		  else
			PartCyln^.InfoSect.BlindSupp :=0;

		  PartCyln^.InfoSect.MENChkSum :=CalcCheck(PartCyln^.CodeSect[0], XCHKSize);

		  {Encrypten}
		  ProtectBM(PartCyln^.CodeSect[0], XCRYSize, PartCyln^.InfoSect.MENRndIdx);

		  InitReadWriteSectors(FirstDrive, INITWRITE);
		  Res :=WriteSectors(FirstDrive, VPos, PartCylnSectorCount, PartCyln);
		  DeInitReadWriteSectors(FirstDrive);

		  if (Res = 0) then begin
			UpdateBM :=TRUE;

		  end else
			MessageBox(BOX_WARN_errHDD_HDR,
			  BOX_WARN + BOX_WARN_errHDD_wrtPCyl,
			  ButtonOK or ButtonDefOK)

		end else
		  MessageBox(BOX_WARN_errFile_HDR,
			BOX_WARN + BOX_WARN_errFile_rdBMgr,
			ButtonOK or ButtonDefOK)

	  end else
		MessageBox(BOX_WARN_errFile_HDR,
		  BOX_WARN + BOX_WARN_errFile_rdMBR,
		  ButtonOK or ButtonDefOK)

	end else
	  MessageBox(BOX_WARN_errFile_HDR,
		BOX_WARN + BOX_WARN_errFile_opnXFD,
		ButtonOK or ButtonDefOK)

  end else
	MessageBox(BOX_WARN_errHDD_HDR,
	  BOX_WARN + BOX_WARN_errHDD_rdPCyl,
	  ButtonOK or ButtonDefOK);

  dispose(PartCyln)
end;
