{
	XFDISK.PAS
	eXtended FDisk I
	----------------------------------------------------------------------
	Copyright (c) 1994-98 by Florian Painke (f.painke@gmx.de).

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful, but
	WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to
		Free Software Foundation, Inc.
		59 Temple Place - Suite 330
		Boston, MA  02111-1307, USA
	or visit the GNU Homepage at http://www.gnu.org/.
}

program XFDisk;

{Code-Erzeugung}
{$IFDEF DEBUG}
  {$I HDEBUG.INC}
{$ELSE}
  {$I HNDEBUG.INC}
{$ENDIF}

{Speicher}
{$M 65520, 204800, 655360}

uses
  DOS, CRT, DiskCtrl, Strings, Misc;

{$I XTYPES.INC}						   {Typdefinitionen}
{$I HLANG.INC}						   {Sprache}

const
  {Versionsinformationen}
  VerInfo	 :TVerInfo = (Tag:		BETA;
						  Prog: 	1;
						  Major:	0;
						  Minor:	7;
						  Patch:	0;
						  Build:	265);

var
  {Globale Variablen}
  DriveChain :PDriveChain;

  PhyDrives  :byte;
  LogDrives  :byte;
  LogStart	 :byte;

  HasChanged :boolean;
  WriteBM	 :boolean;

  BMIsInst	 :boolean;
  BMHasPWDs  :boolean;

  BMUpdate	 :boolean;

  BMNewInst  :boolean;
  BMPrevInst :boolean;
  BMPrevVer  :integer;

  MasterPWD  :array[0..16] of char;
  FloppyPWD  :array[0..16] of char;

  Timeout	 :word;
  TimeHndl	 :byte;
  ClearScrn  :boolean;

  InfoEntr	 :byte;

  MenEntr	 :byte;

  BlindSupp  :boolean;				   {Cursor Anzeigen}
  BootLast	 :boolean;

  CString	 :string[74];
  Parameter  :string;

{$I XIO.INC}						   {Input/Output Routinen}
{$I XBOOTM.INC}						   {BootManager}
{$I XPART.INC}						   {Partitionsverwaltung}
{$I XMENU.INC}						   {Hauptmen}

var
  {Lokale Variablen des Hauptprogrammes}
  CRTBuffer 	   :PCRTBuffer;
  Cnt, Key, CPos   :integer;
  CDrv, MDrv, ODrv :byte;
  CEnt, MEnt, OEnt :integer;
  CAct, MAct, OAct :integer;
  PTable		   :TPTable;
  Res			   :integer;
  WriteMBROnly	   :boolean;

{Mit Fehler beenden}
procedure ExitProgram(Fail :TExit);
begin
  UnloadTable;
  RestoreWindow(CRTBuffer, TRUE);
  halt(ord(Fail));
end;

begin
  CheckBreak :=FALSE;

  {Versionsanzeige}
  CString := STR_PROG_NAME + ' Version ' +
			 Int2Str(VerInfo.Major, 1) + '.' +
			 Int2Str(VerInfo.Minor, 1) + '.' +
			 Int2Str(VerInfo.Patch, 1);

  case (VerInfo.Tag) of
	ALPHA:
	  CString := CString + ' ' + STR_PROG_ALPHA;

	BETA:
	  CString := CString + ' ' + STR_PROG_BETA;

	GAMMA:
	  CString := CString + ' ' + STR_PROG_GAMMA;

	RELEASE:
	  CString := CString + ' ' + STR_PROG_REL;
  end;

  CString := CString + ' ' + STR_PROG_LANG + ', ' + STR_PROG_COPY;
  writeln(ChrArrow, ChrArrow, ChrArrow, ChrSpace, CString);

  {Versionsprfung}
  write('    ', STR_PROG_CHKS);
  XFDISKPath :=ParamStr(0); XHELPPath :=copy(XFDISKPath, 1, length(XFDISKPath) - 3) + 'XFH';
  if (not GetCheck(XFDISKPath)) then begin
	writeln;
	writeln('    ', STR_PROG_ERR_CHKS);
	halt(1)
  end;
  GotoXY(1, wherey); ClrEol;

  {Parameter}
  WriteMBROnly :=FALSE;
  BlindSupp :=FALSE;
  BootLast :=FALSE;

  Cnt :=1;
  while (Cnt <= ParamCount) do begin
	Parameter :=UpStr(ParamStr(Cnt));

	{HardCursor}
	if (Parameter = '/BLIND') then begin
	  BlindSupp :=TRUE;

	{Keine Farbe}
	end else if (Parameter = '/NOCOLOR') or (Parameter = '/MONO') then begin
	  CRTIsMono :=TRUE;
	  CRTSegment :=$B000;

	{MBR erneuern}
	end else if (Parameter = '/MBR') then begin
	  WriteMBROnly :=true;

	{Umsetzungstabelle festlegen}
	end else if (Parameter = '/KEYB') then begin
	  if (Cnt < ParamCount) then
		Parameter :=UpStr(ParamStr(Cnt + 1))
	  else
		Parameter :=SKeyTblTag[KEYBNONE];

	  write('    ', STR_PROG_KEYTBL);

	  Res :=0;
	  Key :=ord(KEYBNONE);
	  Translate :=KEYBNONE;
	  while (Key < ord(EOKEYBTBL)) do begin
		if Parameter = SKeyTblTag[TKeyTbl(Key)] then begin
		  Translate :=TKeyTbl(Key);
		  Res :=Key;
		  inc(Cnt);
		  break;
		end;

		inc(Key);
	  end;

	  {Keine Entsprechung gefunden?}
	  if (Res = 0) then
		Parameter :=SKeyTblTag[KEYBNONE];

	  write(Parameter, ' ', STR_PROG_ANYKEY);
	  ReadKey;
	  GotoXY(1, wherey);
	  ClrEol;

	{Build Information anzeigen}
	end else if (Parameter = '/BUILD') then begin
	  write('    Build ', Int2Str(VerInfo.Build, 3));
	  write(' ', STR_PROG_ANYKEY);
	  ReadKey;
	  GotoXY(1, wherey);
	  ClrEol;
	end;

	inc(Cnt);
  end;

  writeln('    ', STR_PROG_ENV);
  SaveWindow(CRTBuffer);

  if (not BlindSupp) then
	HideCursor;

  {Abfrage ob Festplatte vorhanden}
  PhyDrives :=GetNumberOfDrives;
  if (PhyDrives = 0) then begin
	MessageBox(BOX_WARN_noHDD_HDR,
	  BOX_WARN + BOX_WARN_noHDD,
	  ButtonOK or ButtonDefOK);

	ExitProgram(FAILURE);
  end;

  MasterPWD[0] :=#0;
  FloppyPWD[0] :=#0;

  DriveChain :=nil;
  if (not LoadTable) then begin
	MessageBox(BOX_WARN_errHDD_HDR,
	  BOX_WARN + BOX_WARN_errHDD_rdPTbl,
	  ButtonOK or ButtonDefOK);

	ExitProgram(FAILURE);
  end;

  {Soll nur der MBR geschrieben werden?}
  if (WriteMBROnly) then begin
	for Cnt :=1 to PhyDrives do
	  if (not WriteMBR(FirstDriveIndex + Cnt)) then
		ExitProgram(FAILURE);

	ExitProgram(SUCCESS);
  end;

  {Bildschirmaufbau}
  SetupScreen;

  if (not BlindSupp) then
	HideCursor;

  DisplayTable(FirstDrive, 0);

  {Auswahl}
  MDrv :=FirstDriveIndex + PhyDrives;
  CDrv :=FirstDrive;

  CEnt :=0;
  CAct :=0;
  CPos :=1;

  MEnt :=GetEntries(CDrv, PTable);
  MAct :=MaxLines + 1;

  ODrv :=CDrv;
  OEnt :=CEnt;
  OAct :=CAct;

  DisplayEntry(PTable[CEnt], CAct, TRUE);

  repeat
	Key :=ord(ReadKey);
	if (Key = 0) then
	  Key :=ord(ReadKey) + KeyExtended;

	case (Key) of
	  {Pfeil nach oben}
	  KeyArrowUp: begin
		if (CEnt > 0)  then
		  dec(CEnt);
	  end;

	  {Pfeil nach unten}
	  KeyArrowDown: begin
		if (CEnt < MEnt - 1) then
		  inc(CEnt);
	  end;

	  {Enter - Auswahl}
	  KeyEnter: begin
		MainMenu(CDrv, CEnt, PTable);
		MEnt :=GetEntries(CDrv, PTable);

		if (CEnt > MEnt - 1) then begin
		  dec(CEnt);
		  dec(CAct)
		end;

		DisplayTable(CDrv, CEnt - CAct);

		OEnt :=CEnt;
		OAct :=CAct;

		DisplayEntry(PTable[CEnt], CAct, TRUE)
	  end;

	  {F1 - Hilfe}
	  KeyF1: begin
		ExecHelp('[ALLGEMEIN]');

		DisplayTable(CDrv, CEnt - CAct);
		DisplayEntry(PTable[CEnt], CAct, TRUE)
	  end;

	  {Tab - nchste Festplatte}
	  KeyTab: begin
		if (CDrv = MDrv) then
		  CDrv :=FirstDrive
		else
		  inc(CDrv);

		DisplayEntry(PTable[OEnt], OAct, FALSE);

		CEnt :=0;
		CAct :=0;
		CPos :=1;

		MEnt :=GetEntries(CDrv, PTable);
		MAct :=MaxLines + 1;

		ODrv :=CDrv;
		OEnt :=CEnt;
		OAct :=CAct;

		DisplayTable(CDrv, 0);
		DisplayEntry(PTable[CEnt], CAct, TRUE);
	  end;

	  {F3 - Beenden}
	  KeyF3: begin
		{BootManager mu mindestens einen Eintrag enthalten}
		if ((BMIsInst) and (InfoEntr = 0)) then
		  MenUninstallBM(FALSE);

		{nderungen vorgenommen?}
		if (HasChanged) then begin
		  Res :=MessageBox(BOX_QUERY_wrtPTbl_HDR,
			BOX_QUERY + BOX_QUERY_wrtPTbl,
			ButtonYesNoCancel or ButtonDefNo);

		  {nderungen sichern}
		  if (Res = ButtonResYes) then begin
			{Partitionstabelle schreiben}
			if (not WriteTable) then
			  ExitProgram(FAILURE);

			Res :=MessageBox(BOX_QUERY_rsetPC_HDR,
			  BOX_QUERY + BOX_QUERY_rsetPC,
			  ButtonYesNo or ButtonDefYes);

			{Soll der Reboot durchgefhrt werden?}
			if (Res = ButtonResYes) then begin
			  UnloadTable;
			  ReBoot;
			end else
			  ExitProgram(SUCCESS);

		  {nderungen nicht sichern}
		  end else if (Res = ButtonResNo) then
			ExitProgram(SUCCESS);

		{Keine nderungen, aber BootManager mu neu geschrieben werden?}
		end else if (WriteBM or BMUpdate) then begin
		  Res :=MessageBox(BOX_QUERY_wrtBMgr_HDR,
			BOX_QUERY + BOX_QUERY_wrtBMgr,
			ButtonYesNoCancel or ButtonDefYes);

		  {BootManager schreiben}
		  if (Res = ButtonResYes) then begin
			{Partitionstabelle schreiben}
			if (not WriteTable) then
			  ExitProgram(FAILURE);

			ExitProgram(SUCCESS);

		  {BootManager nicht schreiben}
		  end else if (Res = ButtonResNo) then
			ExitProgram(SUCCESS);

		{Alles klar... keine nderungen, kein BootManager, und Tsch...}
		end else
		  ExitProgram(SUCCESS);


		DisplayTable(CDrv, CEnt - CAct);
		DisplayEntry(PTable[CEnt], CAct, TRUE);
	  end;
	end;

	{Position hat sich gendert?}
	if (CEnt <> OEnt) then begin
	  if (CEnt <= MaxLines) then
		CAct :=CEnt;

	  if ((CEnt > MaxLines) or (OEnt > MaxLines)) then begin
		CAct :=MaxLines;
		DisplayTable(CDrv, CEnt - CAct)
	  end;

	  DisplayEntry(PTable[OEnt], OAct, FALSE);
	  DisplayEntry(PTable[CEnt], CAct, TRUE);
	  OAct :=CAct; OEnt :=CEnt
	end;
  until (Key = 0);
end.
