{
	XIO.INC
	Input/Output Functions and Procedures
	----------------------------------------------------------------------
	Copyright (c) 1994-98 by Florian Painke (f.painke@gmx.de).

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful, but
	WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to
		Free Software Foundation, Inc.
		59 Temple Place - Suite 330
		Boston, MA  02111-1307, USA
	or visit the GNU Homepage at http://www.gnu.org/.
}

{Alarm}
procedure Beep(BeepType :TBeep);
var
  Count :integer;
begin
  case (BeepType) of
	SINGLE: begin
	  sound(880);
	  wait(50);
	  nosound;
	end;

	TRIPLE: begin
	  sound(440);
	  wait(500);
	  nosound;
	end;

	SOS: begin
	  sound(440);
	  wait(500);
	  sound(220);
	  wait(500);
	  nosound;
	end;
  end;

  while (keypressed) do
	readkey;
end;

{InfoBox ausgeben}
function CreateInfoBox(Head, Message :string) :pointer;
var
  Len, Act, Old, Cnt :integer;
  XPs, YPs, Psn 	 :integer;
  Lines 			 :array[0..10] of string;
  CRTBuffer 		 :PCRTBuffer;
begin
  Len :=length(Head) + 2;
  Lines[0] :=Message;
  Cnt :=0;
  repeat
	Psn :=Pos('|', Lines[Cnt]);
	Act :=length(Lines[Cnt]);
	if (Psn <> 0) then begin
	  Lines[Cnt + 1] := Copy(Lines[Cnt], Psn + 1, Act - Psn + 1);
	  Lines[Cnt] :=Copy(Lines[Cnt], 1, Psn - 1);
	  inc(Psn);
	end else
	  Lines[Cnt] :=Copy(Lines[Cnt], 1, Act);

	Len :=Max(length(Lines[Cnt]) + 4, Len);
	inc(Cnt);
  until ((Psn = 0) or (Cnt = 10));

  XPs :=round((80 - Len) / 2);
  YPs :=round((24 - Cnt - 5) / 2);

  {Messagebox ffnen}
  window(XPs , YPs, XPs + Len + 1, YPs + Cnt + 3);
  SaveWindow(CRTBuffer);
  if (CRTIsMono) then
	SetColor(MonMenVG, MonMenBG)
  else
	SetColor(ColMenVG, ColMenBG);
  ClrScr;


  GotoXY(1, 3 + Cnt);
  write('');
  for Act :=2 to Len + 1 do
	write(''); write('');

  GotoXY(1, 1);
  write('');
  for Act :=2 to Len + 1 do
	write(''); write('');

  InsLine;

  for Psn :=2 to 3 + Cnt do begin
	GotoXY(1, Psn);
	write('');
	GotoXY(Len + 2, Psn);
	write('');
  end;

  GotoXY(2 + round((Len - length(Head) - 2) / 2), 1);
  write(' ', Head, ' ');

  if (CRTIsMono) then
	SetColor(MonWinVG, MonWinBG)
  else
	SetColor(ColWinVG, ColWinBG);

  window(XPs + 1, YPs + 1, XPs + Len, YPs + Cnt + 2);
  ClrScr;
  for Psn := 1 to Cnt do begin
	GotoXY(3, Psn + 1);
	write(Lines[Psn - 1]);
	GotoXY(3, Psn + 1);
  end;

  CreateInfoBox :=CRTBuffer;
end;

{InfoBox entfernen}
procedure DestroyInfoBox(var CRTBuffer :pointer);
begin
  RestoreWindow(PCRTBuffer(CRTBuffer), FALSE)
end;


{MessageBox ausgeben}
function MessageBox(Head, Message :string;MBox :word) :integer;
var
  Key, Btn, Def, Cnt :integer;
  Len, Act, Old 	 :integer;
  XPs, YPs, Psn 	 :integer;
  Lines 			 :array[0..10] of string;
  ButtonText		 :array[0..2] of string[10];
  CRTBuffer 		 :PCRTBuffer;
begin
  {Lnge und Position der Box berechnen}
  case (MBox and ButtonMask) of
	{Nur OK-Button}
	ButtonOK: begin
	  ButtonText[0] :=BTN_OK;
	  Btn :=1
	end;

	{Ja, Nein Buttons}
	ButtonYesNo: begin
	  ButtonText[0] :=BTN_YES;
	  ButtonText[1] :=BTN_NO;
	  Btn :=2
	end;

	{Ja, Nein, Abbruch Buttons}
	ButtonYesNoCancel: begin
	  ButtonText[0] :=BTN_YES;
	  ButtonText[1] :=BTN_NO;
	  ButtonText[2] :=BTN_CAN;
	  Btn :=3
	end;
  end;

  {DefaultButton}
  Def :=(MBox and ButtonDefMask) div ButtonDefDiv;
  if (Def >= Btn) then
	Def :=0;

  Len :=length(Head) + 2;
  Lines[0] :=Message;
  Cnt :=0;
  repeat
	Psn :=Pos('|', Lines[Cnt]);
	Act :=length(Lines[Cnt]);
	if (Psn <> 0) then begin
	  Lines[Cnt + 1] := Copy(Lines[Cnt], Psn + 1, Act - Psn + 1);
	  Lines[Cnt] :=Copy(Lines[Cnt], 1, Psn - 1);
	  inc(Psn);
	end else
	  Lines[Cnt] :=Copy(Lines[Cnt], 1, Act);

	Len :=Max(length(Lines[Cnt]) + 4, Len);
	inc(Cnt);
  until ((Psn = 0) or (Cnt = 10));

  Len :=Max(Btn * 10, Len);
  XPs :=round((80 - Len) / 2);
  YPs := round((24 - Cnt - 5) / 2);

  {Messagebox ffnen}
  window(XPs , YPs, XPs + Len + 1, YPs + Cnt + 5);
  SaveWindow(CRTBuffer);
  if (CRTIsMono) then
	SetColor(MonMenVG, MonMenBG)
  else
	SetColor(ColMenVG, ColMenBG);
  ClrScr;


  GotoXY(1, 5 + Cnt);
  write('');
  for Act :=2 to Len + 1 do
	write(''); write('');

  GotoXY(1, 1);
  write('');
  for Act :=2 to Len + 1 do
	write(''); write('');

  InsLine;

  for Psn :=2 to 5 + Cnt do begin
	GotoXY(1, Psn);
	write('');
	GotoXY(Len + 2, Psn);
	write('');
  end;

  GotoXY(2 + round((Len - length(Head) - 2) / 2), 1);
  write(' ', Head, ' ');

  if (CRTIsMono) then
	SetColor(MonWinVG, MonWinBG)
  else
	SetColor(ColWinVG, ColWinBG);

  window(XPs + 1, YPs + 1, XPs + Len, YPs + Cnt + 4);
  ClrScr;
  for Psn := 1 to Cnt do begin
	GotoXY(3, Psn + 1);
	write(Lines[Psn - 1]);
  end;

  {Buttons}
  GotoXY((Len div 2) - 5 * Btn, Cnt + 3);
  write('|');
  for Psn :=1 to Btn do
	write(ButtonText[Psn - 1], '|');

  if (BlindSupp) then
	Beep(SINGLE);

  Act :=Def;
  Old :=Act;
  Psn :=(Len div 2) - 5 * Btn;
  repeat
	if (CRTIsMono) then
	  SetColor(MonSelVG, MonSelBG)
	else
	  SetColor(ColSelVG, ColSelBG);

	GotoXY(Psn + Act * 10 + 1, Cnt + 3);
	write(ButtonText[Act]);
	GotoXY(Psn + Act * 10 + 1, Cnt + 3);

	Key :=ord(ReadKey);
	if (Key = 0) then
	  Key :=ord(ReadKey) + KeyExtended;

	case (Key) of
	  {Pfeil nach links}
	  KeyArrowLeft: begin
		if (Act > 0) then
		  dec(Act);
	  end;

	  {Pfeil nach rechts}
	  KeyArrowRight: begin
		if (Act < Btn - 1) then
		  inc(Act);
	  end;

	  {Tabulator}
	  KeyTab: begin
		if (Act < Btn - 1) then
		  inc(Act)
		else
		  Act :=0;
	  end;
	end;

	if (CRTIsMono) then
	  SetColor(MonWinVG, MonWinBG)
	else
	  SetColor(ColWinVG, ColWinBG);

	GotoXY(Psn + Old * 10 + 1, Cnt + 3);
	write(ButtonText[Old]);
	Old :=Act;
  until (Key = KeyEnter) or (Key = KeyEscape);

  if (Key = KeyEscape) then
	MessageBox :=ButtonResCancel
  else
	MessageBox :=Act;

  RestoreWindow(CRTBuffer, FALSE)
end;

{InputBox ausgeben}
function InputBox(Head, Message :string;
				  var IOStr :string;
				  MaxLen :integer;
				  Align :TAlign;
				  Crypt :boolean) :integer;
var
  Len, Psn, Key, Act :integer;
  XPs, YPs, Cnt 	 :integer;
  InsMode			 :boolean;
  Lines 			 :array[0..10] of string;
  LeftStr, RightStr  :string[64];
  CRTBuffer 		 :PCRTBuffer;
begin
  {Lnge und Position der Box berechnen}
  Len :=length(Head) + 2;
  Lines[0] :=Message;
  Cnt :=0;
  repeat
	Psn :=Pos('|', Lines[Cnt]);
	Act :=Length(Lines[Cnt]);
	if (Psn <> 0) then begin
	  Lines[Cnt + 1] := Copy(Lines[Cnt], Psn + 1, Act - Psn + 1);
	  Lines[Cnt] :=Copy(Lines[Cnt], 1, Psn - 1);
	  inc(Psn);
	end else
	  Lines[Cnt] :=Copy(Lines[Cnt], 1, Act);

	Len :=Max(Length(Lines[Cnt]) + 4, Len);
	inc(Cnt);
  until ((Psn = 0) or (Cnt = 10));

  Len :=Max(MaxLen + 6, Len);
  XPs :=round((80 - Len) / 2);
  YPs := round((24 - Cnt - 5) / 2);

  if (Crypt) then
	LeftStr :=''
  else
	LeftStr :=IOStr;
  RightStr :='';

  {Inputbox ffnen}
  window(XPs , YPs, XPs + Len + 1, YPs + Cnt + 5);
  SaveWindow(CRTBuffer);
  if (CRTIsMono) then
	SetColor(MonMenVG, MonMenBG)
  else
	SetColor(ColMenVG, ColMenBG);
  ClrScr;

  GotoXY(1, Cnt + 5);
  write('');
  for Act :=2 to Len + 1 do
	write(''); write('');

  GotoXY(1, 1);
  write('');
  for Act :=2 to Len + 1 do
	write(''); write('');

  InsLine;

  for Act :=2 to Cnt + 5 do begin
	GotoXY(1, Act);
	write('');
	GotoXY(Len + 2, Act);
	write('');
  end;

  GotoXY(2 + round((Len - length(Head) - 2) / 2), 1);
  write(' ', Head, ' ');

  if (CRTIsMono) then
	SetColor(MonWinVG, MonWinBG)
  else
	SetColor(ColWinVG, ColWinBG);

  window(XPs + 1, YPs + 1, XPs + Len, YPs + Cnt + 4);
  ClrScr;

  for Psn := 1 to Cnt do begin
	GotoXY(3, Psn + 1);
	write(Lines[Psn - 1]);
  end;

  if (CRTIsMono) then
	SetColor(MonSelVG, MonSelBG)
  else
	SetColor(ColSelVG, ColSelBG);

  window(XPs + 2, YPs + Cnt + 3, XPs + MaxLen + 5, YPs + Cnt + 3);
  ClrScr;

  if (BlindSupp) then
	Beep(SINGLE);

  InsMode :=TRUE;
  ShowCursor(CursorIns);
  Cnt :=Length(LeftStr);
  Act :=0;
  repeat
	if (Align = LEFT) then begin
	  GotoXY(3, 1);
	  if (Crypt) then
		write(StrFill('*', length(LeftStr) + length(RightStr)))
	  else
		write(LeftStr, RightStr);
	  ClrEol;
	  GotoXY(3 + Cnt, 1);
	end else begin
	  GotoXY(3, 1);
	  ClrEOL;
	  GotoXY(MaxLen - (length(LeftStr) + length(RightStr)) + 3, 1);
	  if (Crypt) then
		write(StrFill('*', length(LeftStr) + length(RightStr)))
	  else
		write(LeftStr, RightStr);
	  GotoXY(MaxLen - length(RightStr) + 3, 1);
	end;

	Key :=ord(ReadKey);
	if (Key = 0) then
	  Key :=ord(ReadKey) + KeyExtended;

	{Eingabezeichen verarbeiten}
	if ((Key >= KeyMinChr) and (Key <= KeyMaxChr)) then begin
	  {Erstes Zeichen Eingabe? Dann alten Text lschen}
	  if (Act = 0) then begin
		LeftStr :=chr(Key); Cnt :=1;
	  end else begin
		{Insert Mode}
		if (InsMode) then begin
		  if (length(LeftStr) + length(RightStr) < MaxLen) then begin
			LeftStr :=LeftStr + chr(Key);
			inc(Cnt);
		  end else
			Beep(SINGLE);
		{Overwrite Mode}
		end else begin
		  {Ist auf der rechten Seite noch ein Zeichen zum berschreiben?}
		  if (length(RightStr) > 0) then begin
			LeftStr :=LeftStr + chr(Key);
			RightStr :=Copy(RightStr, 2, length(RightStr) - 1);
			inc(Cnt)
		  end else begin
			if (length(LeftStr) < MaxLen) then begin
			  LeftStr :=LeftStr + chr(Key);
			  inc(Cnt)
			end else
			  Beep(SINGLE);
		  end;
		end;
	  end;
	end else begin

	  case (Key) of
		{Backspace}
		KeyBackspace: begin
		  if (length(LeftStr) > 0) then begin
			LeftStr :=Copy(LeftStr, 1, length(LeftStr) - 1);
			dec(Cnt)
		  end else
			Beep(SINGLE);
		end;

		{Delete}
		KeyDelete: begin
		  if (length(RightStr) > 0) then
			RightStr :=Copy(RightStr, 2, length(RightStr) - 1)
		  else
			Beep(SINGLE);
		end;

		{Pfeil nach links}
		KeyArrowLeft: begin
		  if (length(LeftStr) > 0) then begin
			RightStr :=Copy(LeftStr, length(LeftStr), 1) + RightStr;
			LeftStr  :=Copy(LeftStr, 1, length(LeftStr) - 1);
			dec(Cnt)
		  end else
			Beep(SINGLE);
		end;

		{Pfeil nach rechts}
		KeyArrowRight: begin
		  if (length(RightStr) > 0) then begin
			LeftStr  :=LeftStr + Copy(RightStr, 1, 1);
			RightStr :=Copy(RightStr, 2, length(RightStr) - 1);
			inc(Cnt)
		  end else
			Beep(SINGLE);
		end;

		{End}
		KeyEnd: begin
		  if (length(RightStr) > 0) then begin
			LeftStr :=LeftStr + RightStr;
			RightStr :='';
			Cnt :=length(LeftStr);
		  end else
			Beep(SINGLE);
		end;

		{Home}
		KeyHome: begin
		  if (length(LeftStr) > 0) then begin
			RightStr :=LeftStr + RightStr;
			LeftStr :='';
			Cnt :=0;
		  end else
			Beep(SINGLE);
		end;

		{Toggle Insert/Overwrite Mode}
		KeyInsert: begin
		  InsMode := not InsMode;
		  if (InsMode) then
			ShowCursor(CursorIns)
		  else
			ShowCursor(CursorOvr);
		end;
	  end;
	end;
	Act :=Key;
  until ((Key = KeyEnter) or (Key = KeyEscape));

  if (Key = KeyEnter) then begin
	InputBox :=ButtonResOK;
	IOStr :=LeftStr + RightStr;
  end else
	InputBox :=ButtonResCancel;

  if (not BlindSupp) then
	HideCursor
  else
	ShowCursor(CursorIns);

  RestoreWindow(CRTBuffer, FALSE)
end;

{Passwort crypten}
procedure ProtectPWD(Password: PChar; len: byte);
var
  Cnt :byte;
begin
  for Cnt :=0 to 15 do begin
	{$IFDEF DEBUG}
	  {$R-}
	  {$Q-}
	{$ENDIF}
	if (odd(len)) then
	  Password[Cnt] :=chr(ord(Password[Cnt]) xor ord(PWDTable1[Cnt]))
	else
	  Password[Cnt] :=chr(ord(Password[Cnt]) xor ord(PWDTable2[Cnt]));
	{$IFDEF DEBUG}
	  {$R+}
	  {$Q+}
	{$ENDIF}
  end;

  Password[16] :=#0;
end;

{Passwort umsetzen}
function TranslatePWD(var Source: string) :boolean;
var
  CurChr, Key :integer;
  Found, Len  :integer;
  Ch		  :char;
  WorkStr	  :string;
  PKeyTblSrc  :PCKeyTbl;
  PKeyTblDest :PCKeyTbl;
begin
  TranslatePWD :=FALSE;
  if (Translate <> KEYBNONE) then begin
	{Translation Tabelle ermitteln}
	case (Translate) of
	  KEYBGER: begin
		PKeyTblSrc	:=PCKeyTbl(@CGERKeyTblSrc);
		PKeyTblDest :=PCKeyTbl(@CGERKeyTblDest);
	  end;

	  {falls keine gefunden, dann raus hier}
	  else exit;
	end;

	WorkStr :=Source; Len :=length(WorkStr);
	for CurChr :=1 to Len do begin
	  {Zeichen in der Source Tabelle suchen}
	  Ch :=WorkStr[CurChr];
	  Found :=0;
	  for Key :=1 to IKeyTblCnt[Translate] do
		if (PKeyTblSrc^[Key] = Ch) then begin
		  Found :=Key;
		  break;
		end;

	  {Wenn das Zeichen gefunden wurde, nach Tabelle ersetzen}
	  if (Found <> 0) then
		WorkStr[CurChr] :=PKeyTblDest^[Found]

	  {Ansonsten raus hier, ungltiges Zeichen!}
	  else
		exit;
	end;

	Source :=WorkStr;
	TranslatePWD :=TRUE;
  end else
	TranslatePWD :=TRUE;
end;

{Passowort abfragen}
function GetPassword(Title: string; Password: PChar) :boolean;
var
  Pass1, Pass2, Pass3 :string[16];
  Cnt, Res			  :integer;
  Success			  :boolean;
begin
  GetPassword :=FALSE;
  Pass1 :=StrPas(Password);

  Pass2 :='';
  Success :=FALSE;
  Cnt :=MaxErrCount;
  repeat
	Res :=InputBox(BOX_INP_newPass_PRE + Title + BOX_INP_newPass_POST,
	  BOX_INP_newPass, Pass2, 16, LEFT, TRUE);

	if (Res = ButtonResOK) then
	  if (TranslatePWD(Pass2)) then
		Success :=TRUE
	  else
		Beep(TRIPLE);

	dec(Cnt);
  until ( (Res = ButtonResCancel) or (Cnt = 0) or (Success) );

  if (Success) then begin
	{Pawort soll gelscht werden...}
	if (Pass2 = '') then begin
	  {Gibt's berhaupt ein Pawort?}
	  if (Pass1 <> '') then begin
		Res := MessageBox(BOX_QUERY_delPass_PRE + Title + BOX_QUERY_delPass_POST,
		  BOX_QUERY + BOX_QUERY_delPass,
		  ButtonYesNo or ButtonDefNo);

		{Yup. Wir wollen das Pawort wirklich lschen}
		if (Res = ButtonResYes) then begin
		  Pass3 :='';
		  Success :=FALSE;
		  Cnt :=MaxErrCount;
		  repeat
			Res :=InputBox(BOX_INP_confPass_PRE + Title + BOX_INP_confPass_POST,
			  BOX_INP_confPass, Pass3, 16, LEFT, TRUE);

			if (Res = ButtonResOK) then
			  if (TranslatePWD(Pass3)) then
				if (Pass3 = Pass1) then
				  Success :=TRUE
				else
				  Beep(TRIPLE)
			  else
				Beep(TRIPLE);

			dec(Cnt);
		  until ( (Res = ButtonResCancel) or (Cnt = 0) or (Success) );

		  if (Success) then begin
			Password[0] :=#0;
			GetPassword :=TRUE;
			MessageBox(BOX_INFO_delPass_PRE + Title + BOX_INFO_delPass_POST,
			  BOX_INFO + BOX_INFO_delPass,
			  ButtonOK or ButtonDefOk);
		  end;
		end;
	  end;

	{Das Pawort soll festgelegt oder gendert werden}
	end else if (Pass2 <> Pass1) then begin
	  Pass3 :='';
	  Success :=FALSE;
	  Cnt :=MaxErrCount;
	  repeat
		Res :=InputBox(BOX_INP_rtypPass_PRE + Title + BOX_INP_rtypPass_POST,
		  BOX_INP_rtypPass, Pass3, 16, LEFT, TRUE);

		if (Res = ButtonResOK) then
		  if (TranslatePWD(Pass3)) then
			if (Pass3 = Pass2) then
			  Success :=TRUE
			else
			  Beep(TRIPLE)
		  else
			Beep(TRIPLE);

		dec(Cnt);
	  until ( (Res = ButtonResCancel) or (Cnt = 0) or (Success) );

	  {Yup. Wir wollen das Pawort festlegen oder ndern}
	  if (Success) then begin
		{Gibt's ein Passwort? Dann ndern...}
		if (Pass1 <> '') then begin
		  Pass3 :='';
		  Success :=FALSE;
		  Cnt :=MaxErrCount;
		  repeat
			Res :=InputBox(BOX_INP_confPass_PRE + Title + BOX_INP_confPass_POST,
			  BOX_INP_confPass, Pass3, 16, LEFT, TRUE);

			if (Res = ButtonResOK) then
			  if (TranslatePWD(pass3)) then
				if (Pass3 = Pass1) then
				  Success :=TRUE
				else
				  Beep(TRIPLE)
			  else
				Beep(TRIPLE);

			dec(Cnt);
		  until ( (Res = ButtonResCancel) or (Cnt = 3) or (Success) );

		  if (Success) then begin
			StrPCopy(Password, Pass2);
			GetPassword :=TRUE;
			MessageBox(BOX_INFO_chngPass_PRE + Title + BOX_INFO_chngPass_POST,
			  BOX_INFO + BOX_INFO_chngPass,
			  ButtonOK or ButtonDefOK);
		  end;

		{Pawort soll festlegen werden}
		end else begin
		  StrPCopy(Password, Pass2);
		  GetPassword :=TRUE;
		  MessageBox(BOX_INFO_setPass_PRE + Title + BOX_INFO_setPass_POST,
			BOX_INFO + BOX_INFO_setPass,
			ButtonOK or ButtonDefOK);
		end;
	  end;
	end;
  end;
end;

{Men anzeigen}
procedure DisplayMenu(Menu :string);
var
  Cnt, Act :integer;
  Col	   :boolean;
begin
  GotoXY(1, 25);

  Act :=0;
  for Cnt :=1 to length(Menu) do begin
	{Farbauswahl mit '~' toggeln...}
	if (Menu[Cnt] = '~') then
	  Col :=TRUE
	else
	  Col :=FALSE;

	if (Col) then
	  Act :=1 - Act
	else
	  write(Menu[Cnt]);

	if (Act = 1) then
	  if CRTIsMono then
		SetColor(MonMenHI, MonMenBG)
	  else
		SetColor(ColMenHI, ColMenBG)
	else if (CRTIsMono) then
	  SetColor(MonMenVG, MonMenBG)
	else
	  SetColor(ColMenVG, ColMenBG);
  end
end;

{Bildschirm aufbauen}
procedure SetupScreen;
var
  Cnt  :integer;
begin
  if (CRTIsMono) then begin
	TextMode(Mono);
	SetColor(MonMenVG, MonMenBG)
  end else begin
	TextMode(CO80);
	SetColor(ColMenVG, ColMenBG);
  end;

  ClrScr;
  GotoXY((80-length(CString)) div 2, 1);
  write(CString);

  DisplayMenu(WIN_MAIN_STAT);

  window(1, 2, 80, 24);
  if (CRTIsMono) then
	SetColor(MonWinVG, MonWinBG)
  else
	SetColor(ColWinVG, ColWinBG); ClrScr;

  GotoXY(1, 1);
  write('ͻ');
  write('                                                                              ');
  GotoXY(5, 2);
  write(WIN_MAIN_HDR);
  GotoXY(1, 3);
  write('Ķ');
  GotoXY(1, 22);
  write('ͼ');
  GotoXY(1, 22);

  InsLine;

  for Cnt :=4 to 22 do begin
	GotoXY(1,  Cnt);
	write('');
	GotoXY(80, Cnt);
	write('')
  end;

  window(2, 5, 79, 23);
  ClrScr;
end;

{Hilfe ausgeben}
procedure ExecHelp(KeyStr :string);
var
  CRTBuffer 	:PCRTBuffer;
  Cnt, Lns, Pos :integer;
  Old, Key, Cur :integer;
  Line			:string;
  Buffer		:array[0..255] of PChar;
  HelpFile		:Text;
begin
  {$IFDEF DEBUG}
	{$I-}
  {$ENDIF}
  assign(HelpFile, XHELPPath);
  FileMode :=0;
  reset(HelpFile);
  {$IFDEF DEBUG}
	{$I+}
  {$ENDIF}
  if (IOResult = 0) then begin
	repeat
	  readln(HelpFile, Line);
	until (EOF(HelpFile) or (Line = KeyStr));

	if (Line = KeyStr) then begin
	  Lns :=0;
	  repeat
		readln(HelpFile, Line);
		if (Line <> CHelpEndKey) then begin
		  GetMem(Buffer[Lns], length(Line) + 1);
		  StrPCopy(Buffer[Lns], Line);
		  inc(Lns)
		end;
	  until (EOF(HelpFile) or (Line = CHelpEndKey));

	  if (Lns > 0) then begin
		window(40, 3, 78, 23);
		SaveWindow(CRTBuffer);
		if (CRTIsMono) then
		  SetColor(MonMenVG, MonMenBG)
		else
		  SetColor(ColMenVG, ColMenBG);
		ClrScr;

		GotoXY(1, 20);
		write('ͼ');
		GotoXY(1, 1);
		write('ͻ');
		InsLine;
		GotoXY(3, 1);
		write(' ', WIN_HELP_HDR, ' ');

		GotoXY(1,2);
		for Cnt :=2 to 20 do
		  write('                                     ');

		window(42, 4, 76, 23);

		Pos :=0;
		Old :=Lns;
		Cur :=0;
		repeat
		  {Position gendert}
		  if (Pos <> Old) then begin
			for Cnt :=Pos to Pos + 18 do begin
			  GotoXY(1, Cnt - Pos + 1);
			  ClrEOL;
			  if (Cnt < Lns) then
				write(Buffer[Cnt])
			end;
			GotoXY(1, Cur + 1);
		  end;

		  Old :=Pos;

		  Key :=ord(ReadKey);
		  if Key = 0 then
			Key :=ord(ReadKey) + KeyExtended;

		  case Key of
			{Pfeil nach oben}
			KeyArrowUp: begin
			  if (BlindSupp) then
				if (Cur > 0) then begin
				  dec(Cur);
				  GotoXY(1, Cur + 1);
				end else if (Pos > 0) then
				  dec(Pos)
				else
				  Beep(SINGLE)
			  else
				if (Pos > 0) then
				  dec(Pos)
				else
				  Beep(SINGLE);
			end;

			{Pfeil nach unten}
			KeyArrowDown: begin
			  if (BlindSupp) then
				if (Cur < MaxHelpLines) then
				  if (Cur < Lns - Pos - 1) then begin
					inc(Cur);
					GotoXY(1, Cur + 1);
				  end else
					Beep(SINGLE)
				else if (Pos < Lns - (MaxHelpLines + 1)) then
				  inc(Pos)
				else
				  Beep(SINGLE)
			  else
				if (Lns > MaxHelpLines) then
				  if (Pos < Lns - (MaxHelpLines + 1)) then
					inc(Pos)
				  else
					Beep(SINGLE)
				else
				  Beep(SINGLE);
			end;

			{Seite nach oben}
			KeyPageUp: begin
			  if (BlindSupp) then begin
				Cur :=0;
				GotoXY(1, Cur + 1);
			  end;

			  if (Pos = 0) then
				Beep(SINGLE)
			  else if (Pos >= MaxHelpLines) then
				Pos :=Pos - MaxHelpLines
			  else
				Pos :=0;
			end;

			{Seite nach unten}
			KeyPageDown: begin
			  if (BlindSupp) then begin
				Cur :=0;
				GotoXY(1, Cur + 1);
			  end;

			  if (Lns > MaxHelpLines) then
				if (Pos < Lns - (MaxHelpLines + 1)) then
				  Pos :=Pos + MaxHelpLines
				else
				  Beep(SINGLE)
			  else
				Beep(SINGLE);
			end;

			KeyHome: begin
			  if (BlindSupp) then begin
				Cur :=0;
				GotoXY(1, Cur + 1);
			  end;

			  if (Pos = 0) then
				Beep(SINGLE)
			  else
				Pos :=0;
			end;

			KeyEnd: begin
			  if (BlindSupp) then begin
				Cur :=0;
				GotoXY(1, Cur + 1);
			  end;

			  if (Lns > MaxHelpLines) then
				Pos :=Lns - (MaxHelpLines + 1)
			  else
				Beep(SINGLE)
			end;
		  end;

		  if (Lns > MaxHelpLines) then
			if (Pos > Lns - (MaxHelpLines + 1)) then
			  Pos :=Lns - (MaxHelpLines + 1);

		  if (Pos < 0) then
			Pos :=0;
		until Key = KeyEscape;

		for Cnt :=0 to Lns - 1 do
		  FreeMem(Buffer[Cnt], strlen(Buffer[Cnt]) + 1);

		RestoreWindow(CRTBuffer, FALSE);
		window(2, 5, 79, 23);

	  end else MessageBox(BOX_WARN_errFile_HDR,
		BOX_WARN + BOX_WARN_errFile_rdXFH,
		ButtonOK or ButtonDefOK)

	end else MessageBox(BOX_INFO_noHelp_HDR,
	  BOX_INFO + BOX_INFO_noHelp,
	  ButtonOK or ButtonDefOK);
	close(HelpFile)

  end else MessageBox(BOX_WARN_errFile_HDR,
	BOX_WARN + BOX_WARN_errFile_opnXFH,
	ButtonOK or ButtonDefOK)
end;

{Menuroutine}
function DoMenu(X, Y, Men :byte;
				Header :string;
				MenuEntr, MenuHelp :array of TMenuStr;
				MenuActv :array of integer) :integer;
var
  Cnt, Act, Old, Key :integer;
  Width 			 :integer;
begin
  {Men vorbereiten}
  Width := 0;
  for Cnt :=0 to Men - 1 do begin
	if (MenuActv[Cnt] > 0) then begin
	  {Submens mit Pfeil}
	  if (MenuEntr[Cnt, Length(MenuEntr[Cnt])] = ChrArrow) then
		Width := Max(Width, Length(MenuEntr[Cnt]) + 3)

	  {Markierte Mens mit Hkchen}
	  else if (MenuEntr[Cnt, 1] = ChrCheck) then
		Width := Max(Width, Length(MenuEntr[Cnt]) + 3)

	  {Normale Mens zwei Einrcken}
	  else
		Width := Max(Width, Length(MenuEntr[Cnt]) + 4);
	end;
  end;

  {Bildschirmaufbau}
  window(X, Y, X + Width + 3, Y + Men + 1);
  if (CRTIsMono) then
	SetColor(MonWinVG, MonWinBG)
  else
	SetColor(ColWinVG, ColWinBG);
  ClrScr;

  GotoXY(1, Men + 1);
  write('', StrFill('', Width + 2), '');
  GotoXY(1, 1);
  write('', StrFill('', Width + 2), '');
  InsLine;

  GotoXY(3, 1);
  write(' ', Header, ' ');

  GotoXY(1, 2);
  for Cnt :=2 to Men + 1 do
	write('', StrFill(ChrSpace, Width + 2), '');

  window(X + 1, Y + 1, X + Width + 2, Y + Men);
  for Cnt :=0 to Men - 1 do begin
	if (MenuActv[Cnt] > 0) then begin
	  {Submens mit Pfeil darstellen}
	  if (MenuEntr[Cnt, Length(MenuEntr[Cnt])] = ChrArrow) then begin
		MenuEntr[Cnt] := '  ' +
		  Copy(MenuEntr[Cnt], 1, Length(MenuEntr[Cnt]) - 1) +
		  StrFill(' ', Width - Length(MenuEntr[Cnt]) - 2) +
		  Copy(MenuEntr[Cnt], Length(MenuEntr[Cnt]), 1);

	  {Markierte Mens mit Hkchen darstellen}
	  end else if (MenuEntr[Cnt, 1] = ChrCheck) then begin
		MenuEntr[Cnt] :=
		  Copy(MenuEntr[Cnt], 1, 1) + ' ' +
		  Copy(MenuEntr[Cnt], 2, Length(MenuEntr[Cnt]) - 1);

	  {Normale Mens zwei Einrcken}
	  end else
		MenuEntr[Cnt] := '  ' + MenuEntr[Cnt];

	  GotoXY(2, Cnt + 1);
	  write(MenuEntr[Cnt])
	end else begin
	  window(X, Y, X + Width + 3, Y + Men + 1);
	  GotoXY(1, Cnt + 2);
	  write('', StrFill('', Width + 2), '');
	  window(X + 1, Y + 1, X + Width + 2, Y + Men);
	end
  end;

  Act :=0;
  Old :=Act;

  if (CRTIsMono) then
	SetColor(MonSelVG, MonSelBG)
  else
	SetColor(ColSelVG, ColSelBG);

  GotoXY(1, Act + 1);
  ClrEOL;
  write(' ', MenuEntr[Act]);
  GotoXY(1, Act + 1);

  repeat
	Key :=ord(ReadKey);
	if (Key = 0) then
	  Key :=ord(ReadKey) + KeyExtended;

	case Key of
	  {Pfeil nach oben}
	  KeyArrowUp: begin
		if (Act > 0) then
		  dec(Act);
	  end;

	  {Pfeil nach unten}
	  KeyArrowDown: begin
		if (Act < Men - 1) then
		  inc(Act);
	  end;

	  {F1 - Hilfe}
	  KeyF1: begin
		ExecHelp(MenuHelp[Act]);
		window(X + 1, Y + 1, X + Width + 2, Y + Men);
		GotoXY(1, Act + 1);
	  end;
	end;

	{Postition hat sich gendert?}
	if (Act <> Old) then begin
	  if (MenuActv[Act] = 0) then
		if (Old < Act) then
		  inc(Act)
		else
		  dec(Act);

	  if (CRTIsMono) then
		SetColor(MonWinVG, MonWinBG)
	  else
		SetColor(ColWinVG, ColWinBG);

	  GotoXY(1, Old + 1);
	  ClrEOL;
	  write(' ', MenuEntr[Old]);

	  if (CRTIsMono) then
		SetColor(MonSelVG, MonSelBG)
	  else
		SetColor(ColSelVG, ColSelBG);

	  GotoXY(1, Act + 1);
	  ClrEOL;
	  write(' ', MenuEntr[Act]);
	  GotoXY(1, Act + 1);

	  Old :=Act
	end;
  until ((Key = KeyEnter) or (Key = KeyEscape));

  if (Key = KeyEnter) then
	DoMenu :=MenuActv[Act]
  else
	DoMenu :=0;
end;

{Checksumme von XFDISK prfen}
function GetCheck(Path :string) :boolean;
var
  BinFile  :File;
  CheckSum :longint;
  SavedSum :longint;
  S1, S2   :longint;
  Cnt, Tmp :longint;
  Fr	   :word;
  UseMem   :longint;
  ThisByte :byte;
  Buffer   :PBuffer;
begin
  GetCheck :=FALSE;
  assign(BinFile, Path); FileMode :=0; reset(BinFile, 1); CheckSum :=0;
  if (IOResult = 0) then begin
	S1 :=XFDISKSize + XMBRSize + XMENUSize + 4;

	UseMem :=Min(MaxAvail, CheckUseMaxMem);

	if (S1 > 0) then begin
	  if (S1 <= UseMem) then begin
		GetMem(Buffer, S1);
		BlockRead(BinFile, Buffer^, S1, Fr);
		for Cnt :=0 to Fr - 1 do begin
		  {$IFDEF DEBUG}
			{$R-}
			{$Q-}
		  {$ENDIF}
		  CheckSum :=CheckSum + longint(Buffer^[Cnt]) * longint(Cnt + 1);
		  if (odd(CheckSum)) then
			CheckSum :=CheckSum xor XFDCheckOddMask
		  else
			CheckSum :=CheckSum xor XFDCheckEvenMask;
		  {$IFDEF DEBUG}
			{$R+}
			{$Q+}
		  {$ENDIF}
		end;
		FreeMem(Buffer, S1)
	  end else begin
		S2 := UseMem; Tmp :=0;
		GetMem(Buffer, S2);
		repeat
		  BlockRead(BinFile, Buffer^, S2, Fr); Cnt :=0;
		  while ((Tmp < S1) and (Cnt < Fr)) do begin
			{$IFDEF DEBUG}
			  {$R-}
			  {$Q-}
			{$ENDIF}
			CheckSum :=CheckSum + longint(Buffer^[Cnt]) * longint(Tmp + 1);
			if (odd(CheckSum)) then
			  CheckSum :=CheckSum xor XFDCheckOddMask
			else
			  CheckSum :=CheckSum xor XFDCheckEvenMask;
			{$IFDEF DEBUG}
			  {$R+}
			  {$Q+}
			{$ENDIF}
			inc(Tmp); inc(Cnt);
		  end;
		until ((EOF(BinFile)) or (Tmp = S1));
		FreeMem(Buffer, S2)
	  end
	end;
	Seek(BinFile, S1);
	BlockRead(BinFile, SavedSum, 4, Fr);
	if (Fr = 4) then
	  if (CheckSum = SavedSum) then
		GetCheck :=TRUE
  end;
  close(BinFile)
end;
