{
	XMENU.INC
	Main Menu
	----------------------------------------------------------------------
	Copyright (c) 1994-98 by Florian Painke (f.painke@gmx.de).

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful, but
	WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to
		Free Software Foundation, Inc.
		59 Temple Place - Suite 330
		Boston, MA  02111-1307, USA
	or visit the GNU Homepage at http://www.gnu.org/.
}

{Optimale Partitionsgre ermitteln}
function GetSize(SSize, ISize, MSize :longint; Cnt :integer) :longint;
var
  CSize, Size1, Size2 :longint;
begin
  CSize :=longint(Cnt) * 2048;
  Size1 :=SSize; Size2 :=SSize + ISize;
  while (abs(CSize - Size1) > abs(CSize - Size2)) do begin
	Size1 :=Size2;
	Size2 :=Size2 + ISize
  end;

  if (Size1 > MSize) then
	GetSize :=MSize
  else
	GetSize :=Size1
end;

{Partition anlegen}
procedure MenCreatePartition(Drive, Pos :byte);
var
  MEnt, MHlp	:array[0..1] of TMenuStr;
  MAct			:array[0..1] of integer;
  HDriv 		:PDriveChain;
  HPart, WPart	:PPartChain;
  Cnt, Res, Max :integer;
  PartSize		:integer;
  SSize, ISize	:longint;
  CH			:byte;
  CC, CS, ActID :word;
  ValStr		:string;
  ValRes		:integer;
  Success		:boolean;
begin
  HDriv :=DriveChain;
  while (HDriv^.Drive <> Drive) do
	HDriv :=HDriv^.Next;

  HPart :=HDriv^.PartChain;
  Cnt :=0;
  while (Cnt < Pos) do begin
	HPart :=HPart^.Next;
	inc(Cnt)
  end;

  ActID :=0;
  Success :=FALSE;
  {Es kann sowohl eine Partition als auch ein log. Laufwerk angelegt werden}
  if (HPart^.PartStat = PartStatFreePriLog) then begin
	MEnt[0] :=MEN_newPart_PRI;
	MHlp[0] :='[CREATEPART]';
	MAct[0] :=1;

	MEnt[1] :=MEN_newPart_LOG;
	MHlp[1] :='[CREATEPART]';
	MAct[1] :=2;

	Res :=DoMenu(5, 4, 2, MEN_newPart, MEnt, MHlp, MAct);
	if (Res <> 0) then begin
	  if (Res = 1) then
		ActID :=1
	  else
		ActID :=2;
	  Success :=TRUE;
	end;

  {Es kann nur eine Partition angelegt werden}
  end else if (HPart^.PartStat = PartStatFreePri) then begin
	ActID :=3;
	Success :=TRUE;

  {Es kann nur ein log. Laufwerk angelegt werden}
  end else if (HPart^.PartStat = PartStatFreeLog) then begin
	ActID :=4;
	Success :=TRUE;
  end;


  if (Success) then begin
	Max :=round(HPart^.PartSize / 2048);
	Success :=FALSE;
	Cnt :=MaxErrCount;
	repeat
	  str(Max, ValStr);
	  Res :=InputBox(BOX_INP_setPSize_HDR,
		BOX_INP_setPSize_PAR1 + ValStr + BOX_INP_setPSize_POST,
		ValStr, 5, RIGHT, FALSE);

	  if (Res = ButtonDefOK) then begin
		val(ValStr, PartSize, ValRes);
		if ( (ValRes = 0) and (PartSize >= 1) and (PartSize <= Max) ) then
		  Success :=TRUE
		else
		  Beep(TRIPLE);
	  end;

	  dec(Cnt)
	until ( (Res = ButtonResCancel) or (Cnt = 0) or (Success) );

	if (Success) then begin
	  {Es soll nur ein Teilbereich angelegt werden? Dann Auswahl wohin damit}
	  if (PartSize < Max) then begin
		MEnt[0] :=MEN_setPPos_START;
		MHlp[0] :='[CREATEPOS]';
		MAct[0] :=1;

		MEnt[1] :=MEN_setPPos_END;
		MHlp[1] :='[CREATEPOS]';
		MAct[1] :=2;

		if (ActID < 3) then
		  Res :=DoMenu(7, 5, 2, MEN_setPPos, MEnt, MHlp, MAct)
		else
		  Res :=DoMenu(5, 4, 2, MEN_setPPos, MEnt, MHlp, MAct);

		{Wenn keine Auswahl gettigt wurde, dann raus hier}
		if (Res = 0) then
		  exit

		{Ansonsten die Lagedaten berechnen}
		else begin
		  {Immer in ganzen Zylindern}
		  ISize :=HDriv^.Sector * (HDriv^.Head + 1);
		  {Am Anfang des freien Bereiches}
		  if (Res = 1) then begin
			GetPos(CH, CC, CS, HPart^.StartPos);
			{Check wegen erweiterter Partition}
			if ((HPart^.PartStat = PartStatLog) and (CH = 1)) then begin
			  CH :=0;
			  inc(CC);
			  SetPos(CH, CC, CS, HPart^.StartPos);
			  HPart^.PartSize := HPart^.PartSize - longint(HDriv^.Sector) * longint(HDriv^.Head);
			  HPart^.Distance := HPart^.Distance + longint(HDriv^.Sector) * longint(HDriv^.Head);
			end;

			SSize :=GetSize(ISize - ((CH * HDriv^.Sector) + (CS - 1)), ISize, HPart^.PartSize, PartSize);
			ISize :=SSize; SSize :=ISize + HPart^.Distance - 1

		  {Am Ende des freien BEreiches}
		  end else begin
			GetPos(CH, CC, CS, HPart^.EndPos);
			SSize :=GetSize(CH * HDriv^.Sector + CS, ISize, HPart^.PartSize, PartSize);
			ISize :=SSize;
			SSize :=HPart^.Distance + HPart^.PartSize - ISize;
			HPart^.Distance :=SSize
		  end;

		  HPart^.PartSize :=ISize;
		  CC :=SSize div (HDriv^.Sector * (HDriv^.Head + 1));
		  SSize :=SSize mod (HDriv^.Sector * (HDriv^.Head + 1));
		  CH :=SSize div HDriv^.Sector;
		  CS :=SSize mod HDriv^.Sector + 1;

		  {Am Anfang des freien Bereiches}
		  if (Res = 1) then
			SetPos(CH, CC, CS, HPart^.EndPos)
		  {Am Ende des freien Bereiches}
		  else
			SetPos(CH, CC, CS, HPart^.StartPos);
		end;
	  end;

	  {Partitions Status setzen}
	  if (odd(ActID)) then
		HPart^.PartStat :=PartStatPri
	  else
		HPart^.PartStat :=PartStatLog;

	  {Standardpartitionstyp in Abhngigkeit der Gre setzen}
	  if (HPart^.PartSize <= MaxFAT12Size) then
		HPart^.PartType :=PartTypeFAT12
	  else if (HPart^.PartSize <= MaxFAT16SmlSize) then
		HPart^.PartType :=PartTypeFAT16Sml
	  else if (HPart^.PartSize <= MaxFAT16BigSize) then
		HPart^.PartType :=PartTypeFAT16Big
	  else
		HPart^.PartType :=PartTypeFAT32;

	  {Auf evtl. vorhandene aktive primre Partitionen testen}
	  {Mehrere sichtbare Partitionen werden von CleanUpChain behandelt!}
	  if (odd(ActID)) then
		if (HDriv^.PriPart > 0) then begin
		  Cnt :=0;
		  WPart :=HDriv^.PartChain;
		  while (WPart <> nil) do begin
			if (WPart^.PartStat = PartStatAct) then
			  inc(Cnt);
			WPart :=WPart^.Next;
		  end;

		  {noch keine aktiv}
		  if (Cnt = 0) then
			HPart^.PartStat :=PartStatAct;
		end else
		  HPart^.PartStat :=PartStatAct;

	  for Cnt :=1 to MaxSystems do
		if (HPart^.PartType = IPartType[Cnt]) then
		  HPart^.PartSyst :=Cnt;

	  HPart^.IsNew :=TRUE;
	  HasChanged :=TRUE;
	  CleanUpChain
	end;
  end;
end;

procedure MenDeleteEntry(Drive, Pos :byte; Disp :boolean); forward;

{Partition lschen}
procedure MenDeletePartition(Drive, Pos :byte);
var
  HDriv 	   :PDriveChain;
  HPart, WPart :PPartChain;
  Cnt, Res	   :integer;
begin
  Res :=MessageBox(BOX_QUERY_delPart_HDR,
	BOX_QUERY + BOX_QUERY_delPart,
	ButtonYesNo or ButtonDefNo);
  if (Res = ButtonResYes) then begin
	HDriv :=DriveChain;
	while (HDriv^.Drive <> Drive) do
	  HDriv :=HDriv^.Next;

	HPart :=HDriv^.PartChain;
	WPart :=HPart;
	Cnt :=0;
	while (Cnt < Pos) do begin
	  WPart :=HPart;
	  HPart :=HPart^.Next;
	  inc(Cnt)
	end;

	if ((BMIsInst) and (HPart^.PartEntr <> PartEntrNone)) then
	  MenDeleteEntry(Drive, Pos, FALSE);

	if (WPart = HPart) then begin
	  HDriv^.PartChain :=HPart^.Next;
	  dispose(HPart)
	end else begin
	  WPart^.Next :=HPart^.Next;
	  dispose(HPart)
	end;

	HasChanged :=TRUE;
	CleanUpChain
  end
end;

{Partition aktivieren}
procedure MenActivatePartition(Drive, Pos :byte);
var
  HDriv :PDriveChain;
  HPart :PPartChain;
  Cnt	:integer;
begin
  HDriv :=DriveChain;
  while ((HDriv^.Drive <> Drive) and (HDriv <> nil)) do
	HDriv :=HDriv^.Next;

  if (HDriv <> nil) then begin
	HPart :=HDriv^.PartChain;
	Cnt :=0;
	while (HPart <> nil) do begin
	  if (Cnt = Pos) then
		HPart^.PartStat :=PartStatAct
	  else if (HPart^.PartStat = PartStatAct) then
		HPart^.PartStat :=PartStatPri;

	  HPart :=HPart^.Next;
	  inc(Cnt)
	end;

	HasChanged :=TRUE
  end;
end;

{Laufwerk zuordnen}
procedure MenSelectPartition(Drive, Pos :byte);
var
  HDriv :PDriveChain;
  HPart :PPartChain;
  Cnt	:integer;
begin
  HDriv :=DriveChain;
  while ((HDriv^.Drive <> Drive) and (HDriv <> nil)) do
	HDriv :=HDriv^.Next;

  if (HDriv <> nil) then begin
	HPart :=HDriv^.PartChain;
	Cnt :=0;
	while (HPart <> nil) do begin
	  if (Cnt = Pos) then
		HPart^.PartType :=HPart^.PartType - PartMaskHide
	  else if (HPart^.PartType in [$01, $04, $06, $07, $0B, $0C, $0E]) then
		if (HPart^.PartStat = PartStatPri) then
		  HPart^.PartType :=HPart^.PartType + PartMaskHide
		else if (HPart^.PartStat = PartStatAct) then begin
		  HPart^.PartType :=HPart^.PartType + PartMaskHide;
		  MenActivatePartition(Drive, Pos);
		end;

	  HPart :=HPart^.Next;
	  inc(Cnt)
	end;

	CleanUpChain;
	HasChanged :=TRUE
  end;
end;

{Partitionstyp ndern}
procedure MenChangePartType(Drive, Pos :byte);
var
  HDriv 		:PDriveChain;
  HPart, WPart	:PPartChain;
  Cnt, Res, Typ :integer;
  ValStr		:string;
  Success		:boolean;
begin
  HDriv :=DriveChain;
  while (HDriv^.Drive <> Drive) do
	HDriv :=HDriv^.Next;

  HPart :=HDriv^.PartChain;
  WPart :=HPart;
  Cnt :=0;
  while (Cnt < Pos) do begin
	WPart :=HPart;
	HPart :=HPart^.Next;
	inc(Cnt)
  end;

  Success :=FALSE;
  Cnt :=MaxErrCount;
  repeat
	ValStr :=Byte2Hex(HPart^.PartType);
	Res :=InputBox(BOX_INP_setPTyp_HDR,
	 BOX_INP_setPTyp, ValStr, 2, RIGHT, FALSE);

	if (Res = ButtonResOK) then begin
	  ValStr :='$' + ValStr;
	  val(ValStr, Typ, Res);
	  if ( (Res = 0) and (Typ >=1) and (Typ <= 255) ) then
		Success :=TRUE
	  else
		Beep(TRIPLE);
	end;

	dec(Cnt);
  until ( (Res = ButtonResCancel) or (Cnt = 0) or (Success) );

  if (Success) then begin
	if (not HPart^.IsNew) then
	  Res :=MessageBox(BOX_QUERY_chngPTyp_HDR,
		BOX_QUERY + BOX_QUERY_chngPTyp,
		ButtonYesNo or ButtonDefNo)
	else
	  Res :=ButtonResYes;

	if (Res = ButtonResYes) then begin
	  HPart^.PartType :=Typ;
	  HPart^.PartSyst :=PartSystNone;
	  for Cnt :=1 to MaxSystems do
		if (Typ = IPartType[Cnt]) then
		  HPart^.PartSyst :=Cnt;

	  HPart^.IsNew :=TRUE;
	  HasChanged :=TRUE;

	  if ((BMIsInst) and (HPart^.PartEntr <> PartEntrNone)) then
		WriteBM :=TRUE;
	  CleanUpChain;
	end;
  end;
end;

{in Menu aufnehmen}
procedure MenInsertEntry(Drive, Pos :byte);
var
  HDriv :PDriveChain;
  HPart :PPartChain;
  Cnt	:integer;
  Res	:integer;
  Name	:string;
begin
  HDriv :=DriveChain;
  while (HDriv^.Drive <> Drive) do
	HDriv :=HDriv^.Next;

  HPart :=HDriv^.PartChain;
  Cnt :=0;
  while (Cnt < Pos) do begin
	HPart :=HPart^.Next;
	inc(Cnt)
  end;

  Name :='';
  Res :=InputBox(BOX_INP_newEntr_HDR,
	BOX_INP_newEntr, Name, 16, LEFT, FALSE);

  if ( (Res = ButtonResOK) and (Name <> '') ) then begin
	StrPCopy(HPart^.PartName, Name);
	HPart^.PartEntr :=InfoEntr;
	inc(InfoEntr);
	WriteBM :=TRUE
  end
end;

{aus Menu lschen}
procedure MenDeleteEntry(Drive, Pos :byte; Disp :boolean);
var
  HDriv :PDriveChain;
  HPart :PPartChain;
  Cnt	:integer;
  Res	:integer;
begin
  HDriv :=DriveChain;
  while (HDriv^.Drive <> Drive) do
	HDriv :=HDriv^.Next;

  HPart :=HDriv^.PartChain;
  Cnt :=0;
  while (Cnt < Pos) do begin
	HPart :=HPart^.Next;
	inc(Cnt)
  end;

  if (Disp) then
	Res :=MessageBox(BOX_QUERY_delEntr_HDR,
	  BOX_QUERY + BOX_QUERY_delEntr,
	  ButtonYesNo or ButtonDefNo)
  else
	Res :=ButtonResYes;

  if (Res = ButtonResYes) then begin
	HPart^.PartName[0] :=#0;
	HPart^.PartPWD[0] :=#0;
	Res :=HPart^.PartEntr;
	HPart^.PartEntr :=PartEntrNone;
	dec(InfoEntr);

	{Und aufrumen...}
	HDriv :=DriveChain;
	repeat
	  HPart :=HDriv^.PartChain;
	  while (HPart <> nil) do begin
		if ((HPart^.PartEntr > Res) and (HPart^.PartEntr <> PartEntrNone)) then
		  dec(HPart^.PartEntr);
		HPart :=HPart^.Next
	  end;
	  HDriv :=HDriv^.Next;
	until (HDriv = nil);

	WriteBM :=TRUE
  end
end;

{Partitionsname ndern}
procedure MenChangeName(Drive, Pos :byte);
var
  HDriv :PDriveChain;
  HPart :PPartChain;
  Cnt	:integer;
  Res	:integer;
  Name	:string[16];
  Temp	:string[16];
begin
  HDriv :=DriveChain;
  while (HDriv^.Drive <> Drive) do
	HDriv :=HDriv^.Next;

  HPart :=HDriv^.PartChain;
  Cnt :=0;
  while (Cnt < Pos) do begin
	HPart :=HPart^.Next;
	inc(Cnt)
  end;

  if ((HDriv^.Drive = Drive) and (Cnt = Pos)) then begin
	Name :=StrPas(HPart^.PartName);
	Temp :=Name;
	Res :=InputBox(BOX_INP_chngEntr_HDR,
	  BOX_INP_chngEntr, Name, 16, LEFT, FALSE);

	if ((Res = ButtonResOK) and (Name <> '') and (Name <> Temp)) then begin
	  StrPCopy(HPart^.PartName, Name);
	  WriteBM :=TRUE;
	end;
  end;
end;

{Passowrt ndern}
procedure MenChangePassword(Drive, Pos :byte);
var
  HDriv :PDriveChain;
  HPart :PPartChain;
  Cnt	:integer;
begin
  HDriv :=DriveChain;
  while (HDriv^.Drive <> Drive) do
	HDriv :=HDriv^.Next;

  HPart :=HDriv^.PartChain;
  Cnt :=0;
  while (Cnt < Pos) do begin
	HPart :=HPart^.Next;
	inc(Cnt)
  end;

  if ((HDriv^.Drive = Drive) and (Cnt = Pos)) then
	if (GetPassword(MEN_partPass, HPart^.PartPWD)) then
	  WriteBM :=TRUE;
end;

{Timeout Handling festlegen}
procedure MenSetTimeoutHandling;
var
  MEnt, MHlp :array[0..2] of TMenuStr;
  MAct		 :array[0..2] of integer;
  Men		 :integer;
begin
  Men :=0;

  MEnt[Men] :=MEN_setBVal_dactL;
  MHlp[Men] :='[STARTHANDLING]';
  MAct[Men] :=1;
  inc(Men);

  MEnt[Men] :=MEN_setBVal_rsetL;
  MHlp[Men] :='[STARTHANDLING]';
  MAct[Men] :=2;
  inc(Men);

  MEnt[Men] :=MEN_setBVal_ignrL;
  MHlp[Men] :='[STARTHANDLING]';
  MAct[Men] :=3;
  inc(Men);

  {Hkchen setzen}
  MEnt[TimeHndl] := ChrCheck + MEnt[TimeHndl];

  Men :=DoMenu(7, 5, Men, MEN_setBVal_TmLim, MEnt, MHlp, MAct);

  if ((Men > 0) and (Men <> TimeHndl + 1)) then begin
	TimeHndl := Men - 1;
	WriteBM :=TRUE;
  end;
end;


procedure MenInstallBM;
begin
  WriteBM :=TRUE;

  BMIsInst	:=TRUE;
  BMHasPWDs :=TRUE;

  BMUpdate :=FALSE;

  BMNewInst :=TRUE;

  CryptSize :=XCRYSize;
  CheckSize :=XCHKSize;

  Timeout	:=TimeoutDef;
  TimeHndl	:=TimeoutInactivate;
  ClearScrn :=FALSE;
  BootLast	:=FALSE;
end;

procedure MenUninstallBM(Display :boolean);
var
  Res	:integer;
  HDriv :PDriveChain;
  HPart :PPartChain;
begin
  if (Display) then
	Res :=MessageBox(BOX_QUERY_uninBMgr_HDR,
	  BOX_QUERY + BOX_QUERY_uninBMgr,
	  ButtonYesNo or ButtonDefNo)
  else
	Res :=ButtonResYes;

  if (Res = ButtonResYes) then begin
	if (BMPrevInst) then
	  WriteBM :=TRUE
	else
	  WriteBM :=FALSE;

	BMIsInst  :=FALSE;
	BMHasPWDs :=FALSE;

	BMUpdate :=FALSE;

	BMNewInst :=FALSE;

	InfoEntr :=0;

	MasterPWD[0] :=#0;
	FloppyPWD[0] :=#0;

	HDriv :=DriveChain;
	while (HDriv <> nil) do begin
	  HPart :=HDriv^.PartChain;
	  while (HPart <> nil) do begin
		HPart^.PartName[0] :=#0;
		HPart^.PartPWD[0]  :=#0;

		HPart^.PartEntr :=PartEntrNone;

		HPart :=HPart^.Next
	  end;
	  HDriv :=HDriv^.Next;
	end;
  end;
end;

procedure MenUpdateBM;
begin
  if (BMUpdate) then begin
	if (BMPrevVer < BMVersionExtension1) then begin
	  BMHasPWDs :=FALSE;
	  CryptSize :=OldCHKSize;
	  CheckSize :=OldCHKSize;
	end;

	BMUpdate :=FALSE;

  end else begin
	BMHasPWDs :=TRUE;
	CryptSize :=XCRYSize;
	CheckSize :=XCHKSize;

	BMUpdate :=TRUE;
  end;
end;

{Startwerte festlegen.}
procedure MenSetStartVals(Drive , Pos :byte);
var
  MEnt, MHlp	:array[0..7] of TMenuStr;
  MAct			:array[0..7] of integer;
  HDriv 		:PDriveChain;
  HPart, WPart	:PPartChain;
  Cnt, Men, Res :integer;
  ValRes		:integer;
  TimeTemp		:integer;
  TimeStr		:string;
  Success		:boolean;
begin
  HDriv :=DriveChain;
  while ((HDriv^.Drive <> Drive) and (HDriv <> nil)) do
	HDriv :=HDriv^.Next;

  HPart :=HDriv^.PartChain;
  Cnt :=0;
  while (Cnt < Pos) do begin
	HPart :=HPart^.Next;
	inc(Cnt)
  end;

  Men :=0;
  if ((HPart^.PartEntr <> PartEntrNone) and (HPart^.PartEntr > 0)) then begin
	MEnt[Men] :=MEN_setBVal_defP;
	MHlp[Men] :='[STARTAKTPART]';
	MAct[Men] :=1;
	inc(Men);

	WPart :=HPart;
  end;

  if (BootLast) then
	MEnt[Men] :=ChrCheck + MEN_setBVal_BootL
  else
	MEnt[Men] :=MEN_setBVal_BootL;
  MHlp[Men] :='[STARTLASTPART]';
  MAct[Men] :=7;
  inc(Men);

  MEnt[Men] :=MEN_setBVal_TmOut;
  MHlp[Men] :='[STARTTIMEOUT]';
  MAct[Men] :=2;
  inc(Men);

  MEnt[Men] :=Men_setBVal_TmLim + ChrArrow;
  MHlp[Men] :='[STARTHANDLING]';
  MAct[Men] :=5;
  inc(Men);

  if (ClearScrn) then
	MEnt[Men] := ChrCheck + MEN_setBVal_CLRSCR
  else
	MEnt[Men] :=MEN_setBVal_ClrScr;
  MHlp[Men] :='[STARTCLRSCR]';
  MAct[Men] :=6;
  inc(Men);

  if (BMHasPWDs) then begin
	{Trennzeile}
	MAct[Men] :=0;
	inc(Men);

	{Masterpassword}
	if (MasterPWD[0] <> #0) then
	  MEnt[Men] :=MEN_chngMastPass
	else
	  MEnt[Men] :=MEN_setMastPass;
	MHlp[Men] :='[STARTMASTER]';
	MAct[Men] :=3;
	inc(Men);

	{Floppypassword}
	if (FloppyPWD[0] <> #0) then
	  MEnt[Men] :=MEN_chngFlpyPass
	else
	  MEnt[Men] :=MEN_setFlpyPass;
	MHlp[Men] :='[STARTFLOPPY]';
	MAct[Men] :=4;
	inc(Men);
  end;

  case (DoMenu(5, 4, Men, MEN_setBVal, MEnt, MHlp, MAct)) of
	{Aktuelle Partition Default}
	1: begin
	  Cnt :=WPart^.PartEntr; WPart^.PartEntr :=0;
	  HDriv :=DriveChain;

	  {Aufrumen}
	  repeat
		HPart :=HDriv^.PartChain;
		while (HPart <> nil) do begin
		  if ((HPart^.PartEntr < Cnt) and (HPart <> WPart)) then
			inc(HPart^.PartEntr);
		  HPart :=HPart^.Next
		end;
		 HDriv :=HDriv^.Next;
	  until (HDriv = nil);
	   WriteBM :=TRUE;
	end;

	{Timeout Zeit festlegen}
	2: begin
	  {Fehlerzhler}
	  Success :=FALSE;
	  Cnt :=MaxErrCount;
	  repeat
		str(Timeout, TimeStr);
		Res :=InputBox(BOX_INP_setTmOut_HDR,
		  BOX_INP_setTmOut_PAR1 + Int2Str(TimeoutMin, 1) +
		  '..' + Int2Str(TimeoutMax, 1) + BOX_INP_setTmOut_POST,
		  TimeStr, 3, RIGHT, FALSE);

		if (Res = ButtonResOK) then begin
		  val(TimeStr, TimeTemp, ValRes);
		  if (ValRes = 0) then
			Success :=TRUE
		  else
			Beep(TRIPLE);
		end;

		dec(Cnt)
	  until ( (Res = ButtonResCancel) or (Cnt = 0) or (Success) );

	  if (Success) then
		if (TimeTemp <> Timeout) then begin
		  if ((TimeTemp > TimeoutMax)) then
			TimeTemp :=TimeoutMax;

		  if ((TimeTemp < TimeoutMin) and (TimeTemp <> 0)) then
			TimeTemp :=TimeoutMin;

		  Timeout :=TimeTemp;
		  WriteBM :=TRUE;
		end;

	end;

	{Timeout Handling festlegen}
	5: MenSetTimeoutHandling;

	{Bildschirm lschen}
	6: begin
	  ClearScrn := not ClearScrn;
	  WriteBM :=TRUE;
	end;

	{Masterpawort festlegen}
	3: begin
	  if (GetPassword(MEN_mastPass, MasterPWD)) then
		WriteBM :=TRUE;
	end;

	{Floppypawort festlegen}
	4: begin
	  if (GetPassword(MEN_flpyPass, FloppyPWD)) then
		WriteBM :=TRUE;
	end;

	{Letzte Auswahl booten}
	7: begin
	   BootLast :=not BootLast;
	   WriteBM :=TRUE;
	end;
  end;
end;

{Hauptmen}
procedure MainMenu(Drive :byte; Pos :integer; PTable :TPTable);
var
  CRTBuffer  :PCRTBuffer;
  Cnt, Men	 :integer;
  MEnt, MHlp :array[0..19] of TMenuStr;
  MAct		 :array[0..19] of integer;
begin
  {Menuaufbau ermitteln}
  Men :=0;

  {Ist es eine Partition oder ein freier Bereich?}
  if (PTable[Pos]^.PartStat in [PartStatPri, PartStatAct, PartStatLog]) then begin
	MEnt[Men] :=MEN_delPart;
	MHlp[Men] :='[DELETEPART]';
	MAct[Men] :=2;
	inc(Men);

	{Ist die Partition inaktiv?}
	if ((PTable[Pos]^.PartStat = PartStatPri) and (Drive = FirstDrive)) then begin
	  MEnt[Men] :=MEN_actPart;
	  MHlp[Men] :='[ACTIVATEPART]';
	  MAct[Men] :=3;
	  inc(Men);
	end;

	{Ist die Partition verdeckt?}
	if ((PTable[Pos]^.PartStat in [PartStatPri, PartStatAct]) and
		(PTable[Pos]^.PartType in [$11, $14, $16, $17, $1B, $1C, $1E])) then begin

	  MEnt[Men] :=MEN_showPart;
	  MHlp[Men] :='[SELECTDRIVE]';
	  MAct[Men] :=4;
	  inc(Men);
	end;

	{Partitionstyp ndern}
	MEnt[Men] :=MEN_chngPTyp;
	MHlp[Men] :='[CHANGEPARTTYPE]';
	MAct[Men] :=11;
	inc(Men);

	{Trennzeile}
	MAct[Men] :=0;
	inc(Men);

  {Freier Bereich}
  end else if (PTable[Pos]^.PartStat <> PartStatUnusable) then begin
	if (PTable[Pos]^.PartStat = PartStatFreePriLog) then
	   MEnt[Men] :=MEN_newPart + ChrArrow
	else
	  MEnt[Men] :=MEN_newPart;
	MHlp[Men] :='[CREATEPART]';
	MAct[Men] :=1;
	inc(Men);

	{Trennzeile}
	MAct[Men] :=0;
	inc(Men);
  end;

  {Ist der Bootmanager installiert?}
  if (BMIsInst) then begin
	{Ist es auch kein freier Bereich?}
	if (PTable[Pos]^.PartStat in [PartStatPri, PartStatAct, PartStatLog]) then begin
	  {Ist die gewhlte Partition noch nicht im Men?}
	  if ((PTable[Pos]^.PartEntr = PartEntrNone) and (InfoEntr < MaxEntries)) then begin
		MEnt[Men] :=MEN_newEntr;
		MHlp[Men] :='[INSERTENTR]';
		MAct[Men] :=5;
		inc(Men)
	  end else begin
		MEnt[Men] :=MEN_delEntr;
		MHlp[Men] :='[DELETEENTR]';
		MAct[Men] :=6;
		inc(Men);

		MEnt[Men] :=MEN_chngEntr;
		MHlp[Men] :='[CHANGENAME]';
		MAct[Men] :=7;
		inc(Men);

		{Partitionspawort}
		if (BMHasPWDs) then begin
		  if (PTable[Pos]^.PartPWD[0] <> #0) then
			MEnt[Men] :=MEN_chngPartPass
		  else
			MEnt[Men] :=MEN_setPartPass;
		  MHlp[Men] :='[CHANGEPASSWORD]';
		  MAct[Men] :=12;
		  inc(Men);
		end
	  end;

	  {Trennzeile}
	  MAct[Men] :=0;
	  inc(Men);
	end;

	MEnt[Men] :=MEN_uninBMgr;
	MHlp[Men] :='[UNINSTALL]';
	MAct[Men] :=9;
	inc(Men);

	if (not BMNewInst) then begin
	  if (BMUpdate) then
		MEnt[Men] :=ChrCheck + MEN_updBMgr
	  else
		MEnt[Men] :=MEN_updBMgr;
	  MHlp[Men] :='[UPDATE]';
	  MAct[Men] :=13;
	  inc(Men);
	end;

	MEnt[Men] :=MEN_setBVal + ChrArrow;
	MHlp[Men] :='[BOOTMANAGER]';
	MAct[Men] :=10;
	inc(Men);

  end else begin
	MEnt[Men] :=MEN_instBMgr;
	MHlp[Men] :='[INSTALL]';
	MAct[Men] :=8;
	inc(Men)
  end;

  window(1, 1, 80, 25);
  SaveWindow(CRTBuffer);

  DisplayMenu(WIN_MENU_STAT);

  case DoMenu(3, 3, Men, MEN_MAIN_HDR, MEnt, MHlp, MAct) of
	 1: MenCreatePartition(Drive, Pos);

	 2: MenDeletePartition(Drive, Pos);

	 3: MenActivatePartition(Drive, Pos);

	 4: MenSelectPartition(Drive, Pos);

	11: MenChangePartType(Drive, Pos);

	 5: MenInsertEntry(Drive, Pos);

	 6: MenDeleteEntry(Drive, Pos, TRUE);

	 7: MenChangeName(Drive, Pos);

	12: MenChangePassword(Drive, Pos);

	 8: MenInstallBM;

	 9: MenUninstallBM(TRUE);

	13: MenUpdateBM;

	10: MenSetStartVals(Drive, Pos);
  end;

  RestoreWindow(CRTBuffer, FALSE);
  window(2, 5, 79, 23);
end;
