{
	XPART.INC
	Partition Configuration Functions and Procedures
	----------------------------------------------------------------------
	Copyright (c) 1994-98 by Florian Painke (f.painke@gmx.de).

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful, but
	WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to
		Free Software Foundation, Inc.
		59 Temple Place - Suite 330
		Boston, MA  02111-1307, USA
	or visit the GNU Homepage at http://www.gnu.org/.
}

{MBR schreiben}
function WriteMBR(Drive :byte) :boolean;
var
  MBRSect	  :PPartSect;
  ErrCnt, Res :integer;
  Cnt		  :word;
  VPos		  :TPos;
  BinFile	  :File;
begin
  WriteMBR :=FALSE;
  MBRSect :=new(PPartSect); SetPos(0, 0, 1, VPos);

  InitReadWriteSectors(Drive, INITREAD);
  Res :=ReadSectors(Drive, VPos, 1, MBRSect);
  DeInitReadWriteSectors(Drive);

  if (Res = 0) then begin
	FillChar(MBRSect^, 440, 0);

	assign(BinFile, XFDISKPath); FileMode :=0; reset(BinFile, 1);
	if (IOResult = 0) then
	  seek(BinFile, XFDISKSize);
	if (IOResult = 0) then begin
	  BlockRead(BinFile, MBRSect^, XMBRSize, Res);
	  close(BinFile);
	  if (Res = XMBRSize) then begin
		MBRSect^.PartMark  :=Marker;

		InitReadWriteSectors(Drive, INITWRITE);
		Res :=WriteSectors(Drive, VPos, 1, MBRSect);
		DeInitReadWriteSectors(Drive);

		if (Res = 0) then
		  WriteMBR :=TRUE
		else
		  MessageBox(BOX_WARN_errHDD_HDR,
			BOX_WARN + BOX_WARN_errHDD_wrtMBR,
			ButtonOK or ButtonDefOK);
	  end else
		MessageBox(BOX_WARN_errFile_HDR,
		  BOX_WARN + BOX_WARN_errFile_rdMBR,
		  ButtonOK or ButtonDefOK)
	end else
	  MessageBox(BOX_WARN_errFile_HDR,
		BOX_WARN + BOX_WARN_errFile_opnXFD,
		ButtonOK or ButtonDefOK)
  end else
	MessageBox(BOX_WARN_errHDD_HDR,
	  BOX_WARN + BOX_WARN_errHDD_rdMBR,
	  ButtonOK or ButtonDefOK);

  dispose(MBRSect)
end;

{Freiraum feststellen und DriveChain korrigieren}
procedure CleanUpChain;
var
  HDriv 	   :PDriveChain;
  HPart, WPart :PPartChain;
  CH, LogEntr  :byte;
  CC, CS	   :word;
begin
  HDriv :=DriveChain;
  repeat
	HPart :=HDriv^.PartChain;
	{Checken, ob die Partitiostabelle belegt ist...}
	if (HPart <> nil) then begin
	  {Check wegen erweitereter Partition am Anfang}
	  if (HPart^.PartStat = PartStatLog) then
		if (HPart^.PartSize < HDriv^.MinSize) then begin
		  HPart^.PartPos  :=PartPosNone;
		  HPart^.PartEntr :=PartEntrNone;
		  HPart^.PartDriv :=PartDrivNone;
		  HPart^.PartStat :=PartStatFree;
		  HPart^.PartType :=PartTypeNone;
		  HPart^.PartSyst :=PartSystNone;

		  HPart^.PartLabl[0] :=#0;
		  HPart^.PartName[0] :=#0;
		  HPart^.PartPWD[0] :=#0;

		  HPart^.IsNew :=TRUE;
		  HasChanged :=TRUE;
		end else begin
		  GetPos(CH, CC, CS, HPart^.StartPos);
		  if (CH = 1) then begin
			CH :=0; inc(CC);
			SetPos(CH, CC, CS, HPart^.StartPos);
			HPart^.PartSize := HPart^.PartSize - longint(HDriv^.Sector) * longint(HDriv^.Head);
			HPart^.Distance := HPart^.Distance + longint(HDriv^.Sector) * longint(HDriv^.Head);

			HPart^.IsNew :=TRUE;
			HasChanged :=TRUE;
		  end;
		end;

	  {Checken, ob am Anfang noch was frei ist...}
	  if (HPart^.Distance > HDriv^.Sector) then begin
		WPart :=new(PPartChain);

		WPart^.PartDriv :=PartDrivNone;
		WPart^.PartStat :=PartStatFree;
		WPart^.PartType :=PartTypeNone;

		WPart^.Distance :=HDriv^.Sector;
		WPart^.PartSize :=HPart^.Distance - WPart^.Distance;
		SetPos(1, 0, 1, WPart^.StartPos);

		GetPos(CH, CC, CS, HPart^.StartPos);
		if (CS > 1) then
		  dec(CS)
		else begin
		  CS :=HDriv^.Sector;
		  if (CH > 0) then
			dec(CH)
		  else begin
			CH :=HDriv^.Head;
			dec(CC)
		  end
		end;
		SetPos(CH, CC, CS, WPart^.EndPos);

		WPart^.PartSyst :=PartSystNone;
		WPart^.PartEntr :=PartEntrNone;
		WPart^.PartPos	:=PartPosNone;

		WPart^.PartLabl[0] :=#0;
		WPart^.PartName[0] :=#0;
		WPart^.PartPWD[0] :=#0;

		WPart^.Next :=HPart;
		HDriv^.PartChain :=WPart
	  end;

	  {Checken, ob dazwischen noch was frei ist...}
	  HPart :=HDriv^.PartChain;
	  while (HPart^.Next <> nil) do begin
		if (HPart^.Distance + HPart^.PartSize < HPart^.Next^.Distance) then begin
		  WPart :=new(PPartChain);

		  WPart^.PartDriv :=PartDrivNone;
		  WPart^.PartStat :=PartStatFree;
		  WPart^.PartType :=PartTypeNone;

		  WPart^.Distance :=HPart^.Distance + HPart^.PartSize;
		  WPart^.PartSize :=HPart^.Next^.Distance - WPart^.Distance;

		  GetPos(CH, CC, CS, HPart^.EndPos);
		  if (CS < HDriv^.Sector) then
			inc(CS)
		  else begin
			CS :=1;
			if (CH < HDriv^.Head) then
			  inc(CH)
			else begin
			  CH :=0;
			  inc(CC)
			end
		  end;
		  SetPos(CH, CC, CS, WPart^.StartPos);

		  GetPos(CH, CC, CS, HPart^.Next^.StartPos);
		  if (CS > 1) then
			dec(CS)
		  else begin
			CS :=HDriv^.Sector;
			if (CH > 0) then
			  dec(CH)
			else begin
			  CH :=HDriv^.Head ;
			  dec(CC)
			end
		  end;
		  SetPos(CH, CC, CS, WPart^.EndPos);

		  WPart^.PartSyst :=PartSystNone;
		  WPart^.PartEntr :=PartEntrNone;
		  WPart^.PartPos  :=PartPosNone;

		  WPart^.PartLabl[0] :=#0;
		  WPart^.PartName[0] :=#0;
		  WPart^.PartPWD[0] :=#0;

		  WPart^.Next :=HPart^.Next;
		  HPart^.Next :=WPart
		end;

		HPart :=HPart^.Next
	  end;

	  {Checken, ob am Ende noch was frei ist...}
	  if (HPart^.Distance + HPart^.PartSize < HDriv^.Size) then begin
		WPart :=new(PPartChain);

		WPart^.PartDriv :=PartDrivNone;
		WPart^.PartStat :=PartStatFree;
		WPart^.PartType :=PartTypeNone;

		WPart^.Distance :=HPart^.Distance + HPart^.PartSize;
		WPart^.PartSize :=HDriv^.Size - WPart^.Distance;

		GetPos(CH, CC, CS, HPart^.EndPos);
		if (CS < HDriv^.Sector) then
		  inc(CS)
		else begin
		  CS :=1;
		  if (CH < HDriv^.Head) then
			inc(CH)
		  else begin
			CH :=0;
			inc(CC)
		  end
		end;
		SetPos(CH, CC, CS, WPart^.StartPos);

		SetPos(HDriv^.Head, HDriv^.Cylinder, HDriv^.Sector, WPart^.EndPos);

		WPart^.PartSyst :=PartSystNone;
		WPart^.PartEntr :=PartEntrNone;
		WPart^.PartPos	:=PartPosNone;

		WPart^.PartLabl[0] :=#0;
		WPart^.PartName[0] :=#0;
		WPart^.PartPWD[0] :=#0;

		WPart^.Next :=nil;
		HPart^.Next :=WPart
	  end;

	  {Zurcksetzen}
	  HPart :=HDriv^.PartChain;
	  while (HPart <> nil) do begin
		if not (HPart^.PartStat in [PartStatPri, PartStatAct, PartStatLog]) then
		  HPart^.PartStat :=PartStatFree;
		HPart :=HPart^.Next
	  end;

	  {Soo, und jetzt zusammenfassen...}
	  HPart :=HDriv^.PartChain;
	  while (HPart <> nil) do begin
		if (HPart^.PartStat = PartStatFree) then begin
		  WPart :=HPart^.Next;
		  while ((WPart <> nil) and (WPart^.PartStat = PartStatFree)) do begin
			HPart^.PartSize :=HPart^.PartSize + WPart^.PartSize;
			HPart^.EndPos :=WPart^.EndPos;
			HPart^.Next :=WPart^.Next; dispose(WPart);
			WPart :=HPart^.Next
		  end
		end;

		HPart :=HPart^.Next
	  end;

	{Wenn die Partitionstabelle leer ist, dann eine neue anlegen}
	end else begin
	  HPart :=new(PPartChain);

	  HPart^.PartDriv :=PartDrivNone;
	  HPart^.PartStat :=PartStatFree;
	  HPart^.PartType :=PartTypeNone;

	  HPart^.Distance :=HDriv^.Sector;
	  HPart^.PartSize :=HDriv^.Size - HDriv^.Sector;
	  SetPos(1, 0, 1, HPart^.StartPos);
	  SetPos(HDriv^.Head, HDriv^.Cylinder, HDriv^.Sector, HPart^.EndPos);

	  HPart^.PartSyst :=PartSystNone;
	  HPart^.PartEntr :=PartEntrNone;
	  HPart^.PartPos  :=PartPosNone;

	  HPart^.PartLabl[0] :=#0;
	  HPart^.PartName[0] :=#0;
	  HPart^.PartPWD[0] :=#0;

	  HPart^.Next :=nil;
	  HDriv^.PartChain :=HPart
	end;

	HDriv :=HDriv^.Next;
  until (HDriv = nil);

  {Jetzt die Chain korrigieren...}
  HDriv :=DriveChain;
  LogEntr	:=0;
  LogDrives :=0;
  LogStart	:=0;
  repeat
	HPart :=HDriv^.PartChain;

	HDriv^.PriPart :=0;
	HDriv^.ExtPart :=FALSE;
	HDriv^._p1 :=0;
	HDriv^._p2 :=0;

	CS :=0;
	CC :=0;
	CH :=0;
	while (HPart <> nil) do begin
	  inc(CH);

	  {Logisches Laufwerk?}
	  if (HPart^.PartStat = PartStatLog) then begin
		HDriv^.ExtPart :=True;
		inc(LogEntr);

		if (HPart^.PartType in [$01, $04, $06, $07, $0B, $0C, $0E]) then begin
		  inc(LogDrives);
		  HPart^.PartDriv :=LogDrives;
		end else
		  HPart^.PartDriv :=PartDrivNone;

		if (CC = 0) then begin
		  HDriv^._l1 :=CH;
		  CC :=1;
		end;

		HDriv^._l2 :=CH;

	  {Primare Partition?}
	  end else if (HPart^.PartStat in [PartStatPri, PartStatAct]) then begin
		inc(HDriv^.PriPart);

		{Prfen, ob die aktuelle Partition sichtbar ist}
		if (HPart^.PartType in [$01, $04, $06, $07, $0B, $0C, $0E]) then begin
		  {Ist dies die erste sichtbare Partition auf der Platte?}
		  if (CS = 0) then begin
			HPart^.PartDriv :=HDriv^.Drive;
			inc(LogStart);
			CS :=1;
		  {Wenn nicht, dann verstecken}
		  end else begin
			HPart^.PartType :=HPart^.PartType + PartMaskHide;
			HasChanged :=TRUE;
		  end
		end else
		  HPart^.PartDriv :=PartDrivNone;

		if (CC = 0) then
		  HDriv^._p1 :=CH
		else if (HDriv^._p2 = 0) then
		  HDriv^._p2 :=CH
	  end else
		HPart^.PartDriv :=PartDrivNone;

	  HPart :=HPart^.Next
	end;

	if (HDriv^._p2 = 0) then
	  HDriv^._p2 :=CH + 1;

	HDriv :=HDriv^.Next;
  until HDriv = nil;

  {...und die freien Bereiche definieren}
  HDriv :=DriveChain;
  repeat
	CH :=0;
	HPart :=HDriv^.PartChain;
	while (HPart <> nil) do begin
	  inc(CH);

	  {Freier Bereich?}
	  if (HPart^.PartStat = PartStatFree) then
		{Maximal zulssige primre Partitionen?}
		if (HDriv^.PriPart >= MaxPartitions) then
		  HPart^.PartStat :=PartStatUnusable
		{Eine weniger als maximal zulssig?}
		else if (HDriv^.PriPart = (MaxPartitions - 1)) then
		  {Keine logischen Laufwerke?}
		  if (not HDriv^.ExtPart) then
			HPart^.PartStat :=PartStatFreePriLog
		  {Maximal zulssige logische Laufwerke?}
		  else if (LogEntr >= (MaxLogDrives - PhyDrives)) then
			HPart^.PartStat :=PartStatUnusable
		  {Liegt der freie Bereich zulssig?}
		  else if ((CH > HDriv^._p1) and (CH < HDriv^._p2)) then
			HPart^.PartStat :=PartStatFreeLog
		  else HPart^.PartStat :=PartStatUnusable
		{Keine logischen Laufwerke?}
		else if (not HDriv^.ExtPart) then
		  HPart^.PartStat :=PartStatFreePriLog
		{Mehr logische Laufwerke als zulssig?}
		else if (LogEntr >= (MaxLogDrives - PhyDrives)) then
		  {Liegt der freie Bereich zwischen zwei logischen Laufwerken?}
		  if ((CH > HDriv^._l1) and (CH < HDriv^._l2)) then
			HPart^.PartStat :=PartStatUnusable
		  else HPart^.PartStat :=PartStatFreePri
		{Liegt der Bereich zulssig?}
		else if ((CH > HDriv^._p1) and (CH < HDriv^._p2)) then
		  {Liegt der freie Bereich zwischen zwei logischen Laufwerken?}
		  if ((CH > HDriv^._l1) and (CH < HDriv^._l2)) then
			HPart^.PartStat :=PartStatFreeLog
		  else HPart^.PartStat :=PartStatFreePriLog
		else HPart^.PartStat :=PartStatFreePri;

	  {Freier Bereich am Anfang!}
	  if (HPart^.StartPos.Head = 1) then
		{Ist es eine "Mini"-Partition?}
		if (HPart^.PartSize < HDriv^.MinSize) then begin
		  {Ist der freie Bereich auch fr Partitionen vorgesehen?}
		  if (HPart^.PartStat = PartStatFreePriLog) then
			HPart^.PartStat :=PartStatFreePri;
		  {Ist der freie Bereich nur fr logische Laufwerke vorgesehen?}
		  if HPart^.PartStat = PartStatFreeLog then
			HPart^.PartStat :=PartStatUnusable;
		end;

	  HPart :=HPart^.Next
	end;

	HDriv :=HDriv^.Next;
  until HDriv = nil;
end;

{Partitionstabelle laden}
function LoadTable :boolean;

  function CheckBootSect(BootSect :PBootSect; CStr :string) :boolean;
  var
	Cnt :integer;
  begin
	CheckBootSect :=TRUE;
	for Cnt :=1 to length(CStr) do
	  if (BootSect^.PartSyst[Cnt-1] <> ord(CStr[Cnt])) then
		CheckBootSect :=FALSE
  end;

var
  Cnt, CI, CH		:byte;
  CS, CC			:word;
  Res, PCnt 		:integer;
  VPos				:TPos;
  PartSect, HPSect	:PPartSect;
  BootSect			:PBootSect;
  PartCyln			:PPartCyln;
  HDriv 			:PDriveChain;
  HPart, WPart, DPE :PPartChain;
  RealEntr			:integer;
  InfoBox			:pointer;
begin
  LoadTable :=FALSE;

  InfoBox :=CreateInfoBox(BOX_INFO_rdSyst_HDR, BOX_INFO_rdSyst);

  PartSect :=new(PPartSect);
  PartCyln :=new(PPartCyln);

  SetPos(0, 0, BMSectorStart, VPos);

  InitReadWriteSectors(FirstDrive, INITREAD);
  Res :=ReadSectors(FirstDrive, VPos, BMSectorCount, @PartCyln^.CodeSect[0]);
  DeInitReadWriteSectors(FirstDrive);

  if (Res <> 0) then begin
	DestroyInfoBox(InfoBox);
	MessageBox(BOX_WARN_errHDD_HDR,
	  BOX_WARN + BOX_WARN_errHDD_rdBMgr,
	  ButtonOK or ButtonDefOK);

	dispose(PartSect);
	dispose(PartCyln);
	exit;
  end;

  HasChanged :=FALSE;
  WriteBM	 :=FALSE;

  BMIsInst	:=FALSE;
  BMHasPWDs :=FALSE;

  BMUpdate :=FALSE;

  BMNewInst  :=FALSE;
  BMPrevInst :=FALSE;
  BMPrevVer  :=0;

  InfoEntr :=0;
  RealEntr :=0;

  {Prfen, ob der BootManager installiert ist...}
  if (PartCyln^.InfoSect.InfoMark = Marker) then begin
	{Unterschiedliche CryptSize ab Version 1.07}
	if ((PartCyln^.InfoSect.VerMark = Marker) and
		(PartCyln^.InfoSect.VerInfo < BMVersionExtension2)) then begin
	  CryptSize := OldCRYSize;
	  CheckSize := OldCHKSize;
	end;
	{Unterschiedliche CryptSize ab Version 1.05}
	if ((PartCyln^.InfoSect.VerMark <> Marker) or
		(PartCyln^.InfoSect.VerInfo < BMVersionExtension1)) then begin
	  CryptSize := OldCHKSize;
	  CheckSize := OldCHKSize;
	end;

	{Decrypten}
	ProtectBM(PartCyln^.CodeSect[0], CryptSize, PartCyln^.InfoSect.MENRndIdx);

	{Checksumme prfen!}
	{BUG: Checksummenfehler bei Floppy- oder MasterPawort wegen Protect}
	{FIX: Reihenfolge Checksumme/Pawrter gendert}
	if (PartCyln^.InfoSect.MENChkSum = CalcCheck(PartCyln^.CodeSect[0], CheckSize)) then begin
	  {Abzhlen!}
	  {BUG: Tatschliche Anzahl von Entries kann abweichen!}
	  {FIX: berprfung der Anzahl beim laden der Partitionstabelle
			InfoEntr = RealEntr}
	  {BUG: Runtime Error 201: Range Check Overflow
			...InfoEntr[InfoEntr]... bei InfoEntr = MaxEntr}
	  {FIX: Umstellung der Bedingung um Kurzschlu zu bezwecken}
	  while ((InfoEntr < MaxEntries) and
			 (PartCyln^.InfoSect.InfoEntr[InfoEntr].EntrMark = Marker)) do
		inc(InfoEntr);

	  {Anzahl der Entries gltig?}
	  {BUG: Runtime Error 201 wenn fehlerhafter BootManager (InfoEntr - 1)}
	  {FIX: Falls InfoEntr = 0 BootManager deinstallieren}
	  if (InfoEntr > 0) then begin
		BMIsInst :=TRUE;

		BMPrevInst :=TRUE;

		TimeOut :=PartCyln^.InfoSect.WaitTime;
		if (Timeout > TimeoutMax) then
		  Timeout :=TimeoutMax;
		if ((Timeout <> 0) and (Timeout < TimeoutMin)) then
		  Timeout :=TimeoutMin;

		TimeHndl  :=PartCyln^.InfoSect.TimeHndl;
		if not (TimeHndl in [TimeoutInactivate, TimeoutReset, TimeoutIgnore]) then
		  TimeHndl :=TimeoutInactivate;

		if (PartCyln^.InfoSect.ClearScrn = 1) then
		  ClearScrn :=TRUE
		else
		  ClearScrn :=FALSE;

		if (PartCyln^.InfoSect.BootLast = 1) then
		  BootLast :=TRUE
		else
		  BootLast :=FALSE;

		{Passwrter ab Version 1.05}
		if ((PartCyln^.InfoSect.VerMark = Marker) and
			(PartCyln^.InfoSect.VerInfo >= BMVersionExtension1)) then begin

		  if (PartCyln^.InfoSect.MasterPWD.Protection <> 0) then begin
			ProtectPWD(PartCyln^.InfoSect.MasterPWD.Password, PartCyln^.InfoSect.MasterPWD.Protection);
			StrCopy(MasterPWD, PartCyln^.InfoSect.MasterPWD.Password);
		  end;
		  if (PartCyln^.InfoSect.FloppyPWD.Protection <> 0) then begin
			ProtectPWD(PartCyln^.InfoSect.FloppyPWD.Password, PartCyln^.InfoSect.FloppyPWD.Protection);
			StrCopy(FloppyPWD, PartCyln^.InfoSect.FloppyPWD.Password);
		  end;

		  BMHasPWDs :=TRUE;
		  BMPrevVer :=PartCyln^.InfoSect.VerInfo;
		end else
		  BMPrevVer :=BMVersionExtension1 - 1;

	  {Anzahl der Entries ungltig}
	  end else begin
		MessageBox(BOX_WARN_errBMgr_HDR,
		  BOX_WARN + BOX_WARN_errBMgr_INST,
		  ButtonOK or ButtonDefOK);
		UnInstallBM;
	  end;

	{Checksumme ungltig}
	end else begin
	  MessageBox(BOX_WARN_errBMgr_HDR,
		BOX_WARN + BOX_WARN_errBMgr_CHKS,
		ButtonOK or ButtonDefOK);
	  UnInstallBM;
	end;
  end;

  HDriv :=DriveChain;
  for Cnt :=1 to PhyDrives do begin
	DestroyInfoBox(InfoBox);
	InfoBox :=CreateInfoBox(BOX_INFO_rdSyst_HDR,
	  BOX_INFO_rdSyst_PAR1 + Int2Str(Cnt, 1) + '.');

	{Partitionssektor laden}
	SetPos(0, 0, 1, VPos);

	InitReadWriteSectors(FirstDriveIndex + Cnt, INITREAD);
	Res :=ReadSectors(FirstDriveIndex + Cnt, VPos, 1, PartSect);
	DeInitReadWriteSectors(FirstDriveIndex + Cnt);

	if (Res <> 0) then begin
	  DestroyInfoBox(InfoBox);
	  MessageBox(BOX_WARN_errHDD_HDR,
		BOX_WARN + BOX_WARN_errHDD_rdPTbl,
		ButtonOK or ButtonDefOK);

	  dispose(PartSect);
	  dispose(PartCyln);
	  exit;
	end;

	{und die DriveChain initialisieren}
	if (HDriv = nil) then begin
	  HDriv :=new(PDriveChain);
	  DriveChain :=HDriv
	end else begin
	  HDriv^.Next :=new(PDriveChain);
	  HDriv :=HDriv^.Next
	end;

	{BUG: Runtime Error 204 wenn Partitionstabelle ungltig}
	{FIX: Initialisierung des Next Pointers}
	{PartChain und Next Pointer initialisieren}
	HDriv^.PartChain :=nil;
	HDriv^.Next :=nil;

	{DriveFormat eintragen}
	GetDriveFormat(FirstDriveIndex + Cnt, VPos, CI);
	HDriv^.Drive :=FirstDriveIndex + Cnt;

	GetPos(HDriv^.Head, HDriv^.Cylinder, HDriv^.Sector, VPos);

	HDriv^.Size :=longint(HDriv^.Sector) * longint(HDriv^.Cylinder + 1) * longint(HDriv^.Head + 1);
	HDriv^.MinSize := longint(HDriv^.Sector) * longint(HDriv^.Head + 1);

	{Ist die Partitionstabelle gltig?}
	if (PartSect^.PartMark = Marker) then begin
	  {Alle Eintrge durchgehen...}
	  for PCnt :=0 to (MaxPartitions - 1) do begin
		{Ist der Eintrag gltig?}
		if (PartSect^.PartEntr[PCnt].PartType <> 0) then begin
		  {Wenn der erste Eintrag, dann PartChain anlegen}
		  if (HDriv^.PartChain = nil) then begin
			WPart :=new(PPartChain);
			HDriv^.PartChain :=WPart;
			WPart^.Next :=nil
		  end else begin
			WPart :=HDriv^.PartChain;
			HPart :=WPart;

			{Gehrt der Eintrag vor den ersten?}
			if (PartSect^.PartEntr[PCnt].Distance < WPart^.Distance) then begin
			  WPart :=new(PPartChain);
			  WPart^.Next :=HPart;
			  HDriv^.PartChain :=WPart;
			end else begin
			  repeat
				HPart :=WPart;
				WPart :=WPart^.Next;
				DPE :=WPart;
			  until ((WPart^.Distance > PartSect^.PartEntr[PCnt].Distance) or (WPart = nil));
			  WPart :=new(PPartChain);
			  WPart^.Next :=DPE;
			  HPart^.Next :=WPart;
			end;
		  end;
		  BootSect :=new(PBootSect);

		  {Handelt es sich um eine erweiterte Partition?}
		  if (PartSect^.PartEntr[PCnt].PartType = PartTypeExt) then begin
			HPSect :=new(PPartSect);
			HPart :=WPart;

			VPos :=PartSect^.PartEntr[PCnt].StartPos;

			WPart^.PartStat :=PartStatFree;
			WPart^.PartDriv :=PartDrivNone;
			WPart^.PartType :=PartSect^.PartEntr[PCnt].PartType;

			WPart^.PartSize :=PartSect^.PartEntr[PCnt].PartSize;
			WPart^.Distance :=PartSect^.PartEntr[PCnt].Distance;
			WPart^.StartPos :=PartSect^.PartEntr[PCnt].StartPos;
			WPart^.EndPos :=PartSect^.PartEntr[PCnt].EndPos;

			{Alle Logischen Laufwerke einlesen}
			repeat
			  WPart^.PartName[0] :=#0;
			  WPart^.PartLabl[0] :=#0;
			  WPart^.PartPWD[0]  :=#0;

			  WPart^.PartSyst :=PartSystNone;
			  WPart^.PartEntr :=PartEntrNone;

			  WPart^.PartPos  :=PCnt;

			  {Logischer Partitionssektor}
			  InitReadWriteSectors(FirstDriveIndex + Cnt, INITREAD);
			  Res :=ReadSectors(FirstDriveIndex + Cnt, VPos, 1, HPSect);
			  DeInitReadWriteSectors(FirstDriveIndex + Cnt);

			  if Res <> 0 then begin
				DestroyInfoBox(InfoBox);
				MessageBox(BOX_WARN_errHDD_HDR,
				  BOX_WARN + BOX_WARN_errHDD_rdExtP,
				  ButtonOK or ButtonDefOK);

				dispose(HPSect);
				dispose(BootSect);
				dispose(PartSect);
				dispose(PartCyln);
				exit;
			  end;

			  if (HPSect^.PartEntr[0].PartType <> 0) then begin
				{Im Mensystem suchen...}
				if (BMIsInst) then
				  for CI :=0 to InfoEntr - 1 do begin
					{Stimmen alle Angaben berein?}
					if ((PartCyln^.InfoSect.InfoEntr[CI].BootDriv = HDriv^.Drive) and
						(PartCyln^.InfoSect.InfoEntr[CI].BootPos.SecCyl = HPSect^.PartEntr[0].StartPos.SecCyl) and
						(PartCyln^.InfoSect.InfoEntr[CI].BootPos.Head = HPSect^.PartEntr[0].StartPos.Head)) then begin

					  strcopy(WPart^.PartName, PartCyln^.InfoSect.InfoEntr[CI].PartName);

					  {Anzahl der Entries berprfen}
					  inc(RealEntr);

					  {Passwrter an Version 1.05}
					  if ((PartCyln^.InfoSect.VerMark = Marker) and
						  (PartCyln^.InfoSect.VerInfo >= BMVersionExtension1)) then begin

						if (PartCyln^.InfoSect.PWDEntr[CI].Protection <> 0) then begin
						  ProtectPWD(PartCyln^.InfoSect.PWDEntr[CI].Password, PartCyln^.InfoSect.PWDEntr[CI].Protection);
						  StrCopy(WPart^.PartPWD, PartCyln^.InfoSect.PWDEntr[CI].Password);
						end;
					  end;

					  WPart^.PartEntr :=CI;
					end;
				  end;

				WPart^.IsNew :=FALSE;
				WPart^.PartStat :=PartStatLog;
				WPart^.PartType :=HPSect^.PartEntr[0].PartType;
				WPart^.PartDriv :=PartDrivNone;;
				for CI :=1 to MaxSystems do
				  if (HPSect^.PartEntr[0].PartType = IPartType[CI]) then
					WPart^.PartSyst :=CI;

				WPart^.PartSize :=HPSect^.PartEntr[0].PartSize + HPSect^.PartEntr[0].Distance;
				WPart^.EndPos :=HPSect^.PartEntr[0].EndPos;

				{Label im Bootsektor lesen}
				VPos :=HPSect^.PartEntr[0].StartPos;

				InitReadWriteSectors(FirstDriveIndex + Cnt, INITREAD);
				Res :=ReadSectors(FirstDriveIndex + Cnt, VPos, 1, BootSect);
				DeInitReadWriteSectors(FirstDriveIndex + Cnt);

				if (Res <> 0) then begin
				  DestroyInfoBox(InfoBox);
				  MessageBox(BOX_WARN_errHDD_HDR,
					BOX_WARN + BOX_WARN_errHDD_rdBSec,
					ButtonOK or ButtonDefOK);

				  dispose(HPSect);
				  dispose(BootSect);
				  dispose(PartSect);
				  dispose(PartCyln);
				  exit;
				end;

				{Label aus dem Bootsektor kopieren}
				if (BootSect^.PartMark = Marker) then begin
				  for CI :=0 to 10 do
					WPart^.PartLabl[CI] :=chr(BootSect^.PartLabl[CI]);
				  WPart^.PartLabl[11] :=#0
				end;

				{Noch ein Eintrag vorhanden?}
				if (HPSect^.PartEntr[1].Distance <> 0) then begin
				  HPart :=WPart;
				  WPart :=new(PPartChain);

				  WPart^.Next :=HPart^.Next;
				  HPart^.Next :=WPart;

				  WPart^.StartPos :=HPSect^.PartEntr[1].StartPos;
				  WPart^.Distance := PartSect^.PartEntr[PCnt].Distance + HPSect^.PartEntr[1].Distance
				end;

				{Nchstes logisches Laufwerk}
				VPos :=HPSect^.PartEntr[1].StartPos;
			  end;
			until ((Res <> 0) or (HPSect^.PartEntr[1].Distance = 0));
			dispose(HPSect)

		  {Es ist eine primre Partition}
		  end else begin
			WPart^.PartName[0] :=#0;
			WPart^.PartLabl[0] :=#0;
			WPart^.PartPWD[0]  :=#0;

			WPart^.PartSyst :=PartSystNone;
			WPart^.PartEntr :=PartEntrNone;

			WPart^.PartPos	:=PCnt;

			{Im Mensystem nachsehen...}
			if (BMIsInst) then
			  for CI :=0 to InfoEntr - 1 do begin
				{Stimmen alle Angaben berein?}
				if ((PartCyln^.InfoSect.InfoEntr[CI].BootDriv = HDriv^.Drive) and
					(PartCyln^.InfoSect.InfoEntr[CI].BootPos.SecCyl = PartSect^.PartEntr[PCnt].StartPos.SecCyl) and
					(PartCyln^.InfoSect.InfoEntr[CI].BootPos.Head = PartSect^.PartEntr[PCnt].StartPos.Head)) then begin

				  strcopy(WPart^.PartName, PartCyln^.InfoSect.InfoEntr[CI].PartName);

				  {Anzahl der Entries berprfen}
				  inc(RealEntr);

				  {Passwrter an Version 1.05}
				  if ((PartCyln^.InfoSect.VerMark = Marker) and
					  (PartCyln^.InfoSect.VerInfo >= BMVersionExtension1)) then begin

					if (PartCyln^.InfoSect.PWDEntr[CI].Protection <> 0) then begin
					  ProtectPWD(PartCyln^.InfoSect.PWDEntr[CI].Password, PartCyln^.InfoSect.PWDEntr[CI].Protection);
					  StrCopy(WPart^.PartPWD, PartCyln^.InfoSect.PWDEntr[CI].Password);
					end;
				  end;

				  WPart^.PartEntr :=CI;
				end;
			  end;

			WPart^.IsNew :=FALSE;
			WPart^.PartStat :=PartSect^.PartEntr[PCnt].PartStat;
			WPart^.PartType :=PartSect^.PartEntr[PCnt].PartType;
			WPart^.PartDriv :=PartDrivNone;
			for CI :=1 to MaxSystems do
			  if PartSect^.PartEntr[PCnt].PartType = IPartType[CI] then
				WPart^.PartSyst :=CI;

			WPart^.PartSize :=PartSect^.PartEntr[PCnt].PartSize;
			WPart^.Distance :=PartSect^.PartEntr[PCnt].Distance;
			WPart^.StartPos :=PartSect^.PartEntr[PCnt].StartPos;
			WPart^.EndPos :=PartSect^.PartEntr[PCnt].EndPos;
			VPos :=PartSect^.PartEntr[PCnt].StartPos;

			{System im Bootsektor nachsehen}
			InitReadWriteSectors(FirstDriveIndex + Cnt, INITREAD);
			Res :=ReadSectors(FirstDriveIndex + Cnt, VPos, 1, BootSect);
			DeInitReadWriteSectors(FirstDriveIndex + Cnt);

			if (Res <> 0) then begin
			  DestroyInfoBox(InfoBox);
			  MessageBox(BOX_WARN_errHDD_HDR,
				BOX_WARN + BOX_WARN_errHDD_rdBSec,
				ButtonOK or ButtonDefOK);

			  dispose(BootSect);
			  dispose(PartSect);
			  dispose(PartCyln);
			  exit;
			end;

			{Label aus dem Bootsektor kopieren}
			if (BootSect^.PartMark = Marker) then begin
			  for CI :=0 to 10 do
				WPart^.PartLabl[CI] :=chr(BootSect^.PartLabl[CI]);
			  WPart^.PartLabl[11] :=#0;
			end;
		  end;

		  dispose(BootSect)
		end;
	  end;

	{Partitionstabelle ist nicht gltig}
	end else if (not WriteMBR(HDriv^.Drive)) then
	  MessageBox(BOX_WARN_errHDD_HDR,
		BOX_WARN + BOX_WARN_errHDD_wrtMBR,
		ButtonOK or ButtonDefOK);
  end;

  {Anzahl der Entries berprfen}
  if (InfoEntr <> RealEntr) then
	MessageBox(BOX_WARN_errBMgr_HDR,
	  BOX_WARN + BOX_WARN_errBMgr_ENTR,
	  ButtonOK or ButtonDefOK);

  CleanUpChain;

  DestroyInfoBox(InfoBox);

  dispose(PartSect);
  dispose(PartCyln);

  LoadTable :=TRUE;
end;

{Partitionstabelle Schreiben}
function WriteTable :boolean;
var
  PartCyln	   :PPartCyln;		{Temp. Partitionszylidnerstruktur}
  PartSect	   :PPartSect;		{Temp. Partitionssektor (log. LW)}
  BootSect	   :PBootSect;		{Leerer Bootsektor}
  VPos, IPos   :TPos;			{Temp. Positionsstruktur, Erweiterte Part.}
  HDriv 	   :PDriveChain;	{DriveChain}
  HPart 	   :PPartChain; 	{PartitionChain}
  Res		   :integer;		{Fehlerzhler und Result}
  Pos, Cnt	   :integer;		{InfoEntr.Pos (Fkt.glob.), PartSect.Pos}
  IDist, ISize :longint;		{Temp. Distanz und Gre der erw. Partition}
  HCnt		   :longint;
  CH		   :byte;
  CC, CS, HC   :word;
  DoExit	   :boolean;
  IsNew 	   :boolean;
  InfoBox	   :pointer;
begin
  WriteTable :=FALSE;

  InfoBox :=CreateInfoBox(BOX_INFO_wrtChng_HDR, BOX_INFO_wrtChng);

  if (BMIsInst) then begin
	if (BMUpdate) then begin
	  if (not UpdateBM) then begin
		DestroyInfoBox(InfoBox);
		exit;
	  end else begin
		WriteBM :=TRUE;
	  end;
	end else if (BMNewInst) then begin
	  if (not InstallBM) then begin
		DestroyInfoBox(InfoBox);
		exit;
	  end;
	end;
  end else begin
	if (BMPrevInst) then begin
	  if (not UnInstallBM) then begin
		DestroyInfoBox(InfoBox);
		exit;
	  end;
	end;
  end;

  PartCyln :=new(PPartCyln);
  PartSect :=new(PPartSect);
  Bootsect :=new(PBootSect);
  FillChar(BootSect^, 512, EmptyBootSect);

  HDriv :=DriveChain;

  {Bootmanager einlesen}
  if ( (BMIsInst) and (WriteBM) ) then begin
	SetPos(0, 0, BMSectorStart, VPos);

	InitReadWriteSectors(FirstDrive, INITREAD);
	Res :=ReadSectors(FirstDrive, VPos, BMSectorCount, @PartCyln^.CodeSect[0]);
	DeInitReadWriteSectors(FirstDrive);

	if (Res <> 0) then begin
	  DestroyInfoBox(InfoBox);
	  MessageBox(BOX_WARN_errHDD_HDR,
		BOX_WARN + BOX_WARN_errHDD_rdBMgr,
		ButtonOK or ButtonDefOK);

	  dispose(BootSect);
	  dispose(PartSect);
	  dispose(PartCyln);
	  exit;
	{Decrypten}
	end else
	  ProtectBM(PartCyln^.CodeSect[0], CryptSize, PartCyln^.InfoSect.MENRndIdx);
  end;

  {DriveChain abarbeiten}
  repeat
	SetPos(0, 0, 1, VPos);

	DestroyInfoBox(InfoBox);
	InfoBox :=CreateInfoBox(BOX_INFO_wrtChng_HDR,
	  BOX_INFO_wrtChng_PAR1 + Int2Str(HDriv^.Drive - FirstDriveIndex, 1) + '.');


	InitReadWriteSectors(HDriv^.Drive, INITREAD);
	Res :=ReadSectors(HDriv^.Drive, VPos, 1, PartCyln);
	DeInitReadWriteSectors(HDriv^.Drive);

	if (Res = 0) then begin
	  {Puffer aufrumen...}
	  FillChar(PartCyln^.PartSect.PartEntr[0], 64, 0);

	  {...und die Variablen initialisieren}
	  ISize :=0;
	  Cnt :=0;

	  HPart :=HDriv^.PartChain;
	  {Und jetzt die Partitionstabelle neu schreiben...}
	  while HPart <> nil do begin
		{Ist es ein logisches Laufwerk?}
		if HPart^.PartStat = PartStatLog then begin
		  {Dann erstmal die Position in der Partitionstabelle festhalten}
		  IPos	 :=HPart^.StartPos;
		  IDist  :=HPart^.Distance;

		  DoExit :=FALSE;

		  repeat
			ISize :=ISize + HPart^.PartSize;
			VPos :=HPart^.StartPos;
			IsNew :=HPart^.IsNew;

			{Erweiterte Tabellen laden und ausfllen}
			InitReadWriteSectors(HDriv^.Drive, INITREAD);
			Res :=ReadSectors(HDriv^.Drive, VPos, 1, PartSect);
			DeInitReadWriteSectors(HDriv^.Drive);

			if (Res <> 0) then begin
			  DestroyInfoBox(InfoBox);
			  MessageBox(BOX_WARN_errHDD_HDR,
				BOX_WARN + BOX_WARN_errHDD_rdExtP,
				ButtonOK or ButtonDefOK);

			  dispose(BootSect);
			  dispose(PartSect);
			  dispose(PartCyln);
			  exit;
			end;

			{Partitionstabelle lschen}
			if ((IsNew) or (PartSect^.PartMark <> Marker)) then
			  FillChar(PartSect^, 512, 0)
			else
			  FillChar(PartSect^.PartEntr[0], 64, 0);

			PartSect^.PartEntr[0].PartStat :=PartStatAct;

			GetPos(CH, CC, CS, HPart^.StartPos);
			if (CH < HDriv^.Head) then
			  inc(CH)
			else begin
			  CH :=0;
			  inc(CC)
			end;
			SetPos(CH, CC, 1, PartSect^.PartEntr[0].StartPos);
			PartSect^.PartEntr[0].EndPos   :=HPart^.EndPos;

			PartSect^.PartEntr[0].PartType :=HPart^.PartType;
			PartSect^.PartEntr[0].Distance :=HDriv^.Sector - CS + 1;
			PartSect^.PartEntr[0].PartSize :=HPart^.PartSize - PartSect^.PartEntr[0].Distance;

			{BootManager Men}
			if (HPart^.PartEntr <> PartEntrNone) then begin
			  Pos :=HPart^.PartEntr;
			  PartCyln^.InfoSect.InfoEntr[Pos].BootDriv :=HDriv^.Drive;
			  SetPos(CH, CC, 1, PartCyln^.InfoSect.InfoEntr[Pos].BootPos);

			  PartCyln^.InfoSect.InfoEntr[Pos].PartSize :=round(PartSect^.PartEntr[0].PartSize / 2048);
			  PartCyln^.InfoSect.InfoEntr[Pos].Distance :=HPart^.Distance + HDriv^.Sector - CS + 1;

			  {BUG: Runtime Error 201: Range Check Overflow
					...PartDriv + Logstart... bei PartDriv = PartDrivNone}
			  {FIX: Prfen, ob das logische Laufwerk gltig ist}
			  if (HPart^.PartDriv <> PartDrivNone) then
				PartCyln^.InfoSect.InfoEntr[Pos].PartLDrv :=HPart^.PartDriv + LogStart + FirstDriveIndex
			  else
				PartCyln^.InfoSect.InfoEntr[Pos].PartLDrv :=0;

			  {BUG: berlauf bei PartSyst = PartSystNone}
			  {FIX: Prfen ob PartSyst gltig ist}
			  if (HPart^.PartSyst <> PartSystNone) then
				PartCyln^.InfoSect.InfoEntr[Pos].PartType :=HPart^.PartSyst - 1
			  else
				PartCyln^.InfoSect.InfoEntr[Pos].PartType :=PartSystNone;
			  PartCyln^.InfoSect.InfoEntr[Pos].PartEntr :=0;

			  StrCopy(PartCyln^.InfoSect.InfoEntr[Pos].PartName, HPart^.PartName);
			  FillChar(PartCyln^.InfoSect.PWDEntr[Pos], 18, 0);

			  {Passwort}
			  if (HPart^.PartPWD[0] <> #0) then begin
				StrCopy(PartCyln^.InfoSect.PWDEntr[Pos].Password, HPart^.PartPWD);
				ProtectPWD(PartCyln^.InfoSect.PWDEntr[Pos].Password, StrLen(HPart^.PartPWD));
				PartCyln^.InfoSect.PWDEntr[Pos].Protection :=StrLen(HPart^.PartPWD);
			  end;
			  PartCyln^.InfoSect.InfoEntr[Pos].EntrMark :=Marker;
			end;

			{Freie Bereiche berspringen, falls sie Status 64 haben (nur log. Laufwerk)}
			while ((HPart^.Next <> nil) and
				   (HPart^.Next^.PartStat = PartStatFreeLog)) do
			  HPart := HPart^.Next;

			if ((HPart^.Next <> nil) and (HPart^.Next^.PartStat = PartStatLog)) then begin
			  HPart := HPart^.Next;
			  PartSect^.PartEntr[1].PartStat :=PartStatPri;
			  PartSect^.PartEntr[1].PartType :=PartTypeExt;

			  PartSect^.PartEntr[1].StartPos :=HPart^.StartPos;
			  PartSect^.PartEntr[1].EndPos	 :=HPart^.EndPos;
			  PartSect^.PartEntr[1].Distance :=HPart^.Distance - IDist;
			  PartSect^.PartEntr[1].PartSize :=HPart^.PartSize;
			end else
			  DoExit :=TRUE;

			PartSect^.PartMark :=Marker;

			if (HasChanged) then begin
			  {erweiterte Partitionstabelle schreiben}
			  InitReadWriteSectors(HDriv^.Drive, INITWRITE);
			  Res :=WriteSectors(HDriv^.Drive, VPos, 1, PartSect);
			  DeInitReadWriteSectors(HDriv^.Drive);

			  if (Res <> 0) then begin
				DestroyInfoBox(InfoBox);
				MessageBox(BOX_WARN_errHDD_HDR,
				  BOX_WARN + BOX_WARN_errHDD_wrtExtP,
				  ButtonOK or ButtonDefOK);

				dispose(BootSect);
				dispose(PartSect);
				dispose(PartCyln);
				exit;
			  end;

			  {Bootsektor schreiben}
			  {BUG: Partitionen wurden nicht richtig formatiert}
			  {FIX: n div 256 + 1 Tracks lschen (n = Gre der Partition)}
			  if (IsNew) then begin
				VPos :=PartSect^.PartEntr[0].StartPos;

				GetPos( CH, CC, CS, VPos);
				HCnt :=PartSect^.PartEntr[0].PartSize div HDriv^.Sector;
				HCnt :=HCnt div 256 + 1;

				InitReadWriteSectors(HDriv^.Drive, INITWRITE);
				repeat
				  SetPos( CH, CC, 1, VPos);
				  Res :=WriteSectors(HDriv^.Drive, VPos, 1, BootSect);
				  SetPos( CH, CC, 7, VPos);
				  if (Res = 0) then
					Res :=WriteSectors(HDriv^.Drive, VPos, 1, BootSect);

				  inc(CH);
				  if (CH > HDriv^.Head) then begin
					inc(CC);
					CH :=0;
				  end;

				  dec(HCnt);
				until ((Res <> 0) or (HCnt = 0));
				DeInitReadWriteSectors(HDriv^.Drive);

				if (Res <> 0) then begin
				  DestroyInfoBox(InfoBox);
				  MessageBox(BOX_WARN_errHDD_HDR,
					BOX_WARN + BOX_WARN_errHDD_wrtBSec,
					ButtonOK or ButtonDefOK);

				  dispose(BootSect);
				  dispose(PartSect);
				  dispose(PartCyln);
				  exit;
				end;
			  end;
			end;
		  until (DoExit);

		  {Eintrag in die Haupttabelle}
		  PartCyln^.PartSect.PartEntr[Cnt].PartStat :=PartStatPri;
		  PartCyln^.PartSect.PartEntr[Cnt].PartType :=PartTypeExt;
		  PartCyln^.PartSect.PartEntr[Cnt].StartPos :=IPos;
		  PartCyln^.PartSect.PartEntr[Cnt].EndPos	:=HPart^.EndPos;
		  PartCyln^.PartSect.PartEntr[Cnt].Distance :=IDist;
		  PartCyln^.PartSect.PartEntr[Cnt].PartSize :=ISize;

		  inc(cnt);

		{Ist es eine primre Partition?}
		end else if (HPart^.PartStat in [PartStatPri, PartStatAct]) then begin
		  IsNew :=HPart^.IsNew;

		  {Eintrag in die Haupttabelle Primre Partition}
		  PartCyln^.PartSect.PartEntr[Cnt].PartStat :=HPart^.PartStat;
		  PartCyln^.PartSect.PartEntr[Cnt].PartType :=HPart^.PartType;

		  PartCyln^.PartSect.PartEntr[Cnt].StartPos :=HPart^.StartPos;
		  PartCyln^.PartSect.PartEntr[Cnt].EndPos	:=HPart^.EndPos;
		  PartCyln^.PartSect.PartEntr[Cnt].Distance :=HPart^.Distance;
		  PartCyln^.PartSect.PartEntr[Cnt].PartSize :=HPart^.PartSize;

		  {BootManager Men}
		  if (HPart^.PartEntr <> PartEntrNone) then begin
			Pos :=HPart^.PartEntr;
			PartCyln^.InfoSect.InfoEntr[Pos].BootDriv :=HDriv^.Drive;
			PartCyln^.InfoSect.InfoEntr[Pos].BootPos  :=HPart^.StartPos;

			{BUG: berlauf bei PartSyst = PartSystNone}
			{FIX: Prfen ob PartSyst gltig ist}
			if (HPart^.PartSyst <> PartSystNone) then
			  PartCyln^.InfoSect.InfoEntr[Pos].PartType :=HPart^.PartSyst - 1
			else
			  PartCyln^.InfoSect.InfoEntr[Pos].PartType :=PartSystNone;
			PartCyln^.InfoSect.InfoEntr[Pos].PartLDrv :=0;
			PartCyln^.InfoSect.InfoEntr[Pos].PartEntr :=Cnt + 1;

			PartCyln^.InfoSect.InfoEntr[Pos].PartSize :=round(HPart^.PartSize / 2048);
			PartCyln^.InfoSect.InfoEntr[Pos].Distance :=HPart^.Distance;

			StrCopy(PartCyln^.InfoSect.InfoEntr[Pos].PartName, HPart^.PartName);
			FillChar(PartCyln^.InfoSect.PWDEntr[Pos], 18, 0);

			{Paswort}
			if (HPart^.PartPWD[0] <> #0) then begin
			  StrCopy(PartCyln^.InfoSect.PWDEntr[Pos].Password, HPart^.PartPWD);
			  ProtectPWD(PartCyln^.InfoSect.PWDEntr[Pos].Password, StrLen(HPart^.PartPWD));
			  PartCyln^.InfoSect.PWDEntr[Pos].Protection :=StrLen(HPart^.PartPWD);
			end;
			PartCyln^.InfoSect.InfoEntr[Pos].EntrMark :=Marker;
		  end;

		  {Bootsektor schreiben}
		  {BUG: Partitionen wurden nicht richtig formatiert}
		  {FIX: n div 256 + 1 Tracks lschen (n = Gre der Partition)}
		  if (IsNew) then begin
			VPos :=PartCyln^.PartSect.PartEntr[Cnt].StartPos;

			GetPos( CH, CC, CS, VPos);
			HCnt :=PartCyln^.PartSect.PartEntr[Cnt].PartSize div HDriv^.Sector;
			HCnt :=HCnt div 256 + 1;

			InitReadWriteSectors(HDriv^.Drive, INITWRITE);
			repeat
			  SetPos( CH, CC, 1, VPos);
			  Res :=WriteSectors(HDriv^.Drive, VPos, 1, BootSect);
			  SetPos( CH, CC, 7, VPos);
			  if (Res = 0) then
				Res :=WriteSectors(HDriv^.Drive, VPos, 1, BootSect);

			  inc(CH);
			  if (CH > HDriv^.Head) then begin
				inc(CC);
				CH :=0;
			  end;

			  dec(HCnt);
			until ((Res <> 0) or (HCnt = 0));
			DeInitReadWriteSectors(HDriv^.Drive);

			if (Res <> 0) then begin
			  DestroyInfoBox(InfoBox);
			  MessageBox(BOX_WARN_errHDD_HDR,
				BOX_WARN + BOX_WARN_errHDD_wrtBSec,
				ButtonOK or ButtonDefOK);

			  dispose(BootSect);
			  dispose(PartSect);
			  dispose(PartCyln);
			  exit;
			end;
		  end;

		  inc(cnt);
		end;

		HPart :=HPart^.Next
	  end

	end else begin
	  DestroyInfoBox(InfoBox);
	  MessageBox(BOX_WARN_errHDD_HDR,
		BOX_WARN + BOX_WARN_errHDD_rdPTbl,
		ButtonOK or ButtonDefOK);

	  dispose(BootSect);
	  dispose(PartSect);
	  dispose(PartCyln);
	  exit;
	end;

	{BUG: falsche Partitionstabellensortierung konnte BM durcheinanderbringen}
	{FIX: Partitionstabelle auch schreiben, wenn nur der BootManager
		  installiert/upgedated wird}
	if ( (HasChanged) or ((BMIsInst) and (WriteBM)) ) then begin
	  {Partitionstabelle schreiben...}
	  SetPos(0, 0, 1, VPos);

	  InitReadWriteSectors(HDriv^.Drive, INITWRITE);
	  Res :=WriteSectors(HDriv^.Drive, VPos, 1, PartCyln);
	  DeInitReadWriteSectors(HDriv^.Drive);

	  if (Res <> 0) then begin
		DestroyInfoBox(InfoBox);
		MessageBox(BOX_WARN_errHDD_HDR,
		  BOX_WARN + BOX_WARN_errHDD_wrtPTbl,
		  ButtonOK or ButtonDefOK);

		dispose(BootSect);
		dispose(PartSect);
		dispose(PartCyln);
		exit;
	  end;
	end;

	HDriv :=HDriv^.Next;
  until (HDriv = nil);

  if ( (BMIsInst) and (WriteBM) ) then begin
	{Reste lschen!!!}
	{BUG: Runtime Error 201: Range Check Overflow
		  ...InfoEntr[InfoEntr]... bei InfoEntr = MaxEntr}
	{FIX: Puffer nur lschen, wenn ntig, also InfoEntr < MaxEntr}
	if (InfoEntr < MaxEntries) then begin
	  FillChar(PartCyln^.InfoSect.InfoEntr[InfoEntr], (MaxEntries - InfoEntr) * 32, 0);
	  FillChar(PartCyln^.InfoSect.PWDEntr[InfoEntr], (MaxEntries - InfoEntr) * 18, 0);
	end;

	{Passwrter}
	FillChar(PartCyln^.InfoSect.MasterPWD, 18, 0);
	if (MasterPWD[0] <> #0) then begin
	  StrCopy(PartCyln^.InfoSect.MasterPWD.Password, MasterPWD);
	  ProtectPWD(PartCyln^.InfoSect.MasterPWD.Password, StrLen(MasterPWD));
	  PartCyln^.InfoSect.MasterPWD.Protection :=StrLen(MasterPWD);
	end;

	FillChar(PartCyln^.InfoSect.FloppyPWD, 18, 0);
	if (FloppyPWD[0] <> #0) then begin
	  StrCopy(PartCyln^.InfoSect.FloppyPWD.Password, FloppyPWD);
	  ProtectPWD(PartCyln^.InfoSect.FloppyPWD.Password, StrLen(FloppyPWD));
	  PartCyln^.InfoSect.FloppyPWD.Protection :=StrLen(FloppyPWD);
	end;

	PartCyln^.InfoSect.WaitTime  :=Timeout;
	PartCyln^.InfoSect.TimeHndl  :=TimeHndl;

	if (ClearScrn) then
	  PartCyln^.InfoSect.ClearScrn :=1
	else
	  PartCyln^.InfoSect.ClearScrn :=0;

	PartCyln^.InfoSect.LastEntry :=0;
	if (BootLast) then
	  PartCyln^.InfoSect.BootLast :=1
	else
	  PartCyln^.InfoSect.BootLast :=0;

	PartCyln^.InfoSect.MENChkSum :=CalcCheck(PartCyln^.CodeSect[0], CheckSize);

	{Encrypten}
	ProtectBM(PartCyln^.CodeSect[0], CryptSize, PartCyln^.InfoSect.MENRndIdx);

	SetPos(0, 0, BMSectorStart, VPos);

	InitReadWriteSectors(FirstDrive, INITWRITE);
	Res :=WriteSectors(FirstDrive, VPos, BMSectorCount, @PartCyln^.CodeSect[0]);
	DeInitReadWriteSectors(FirstDrive);

	if (Res <> 0) then
	  MessageBox(BOX_WARN_errHDD_HDR,
		BOX_WARN + BOX_WARN_errHDD_wrtBMgr,
		ButtonOK or ButtonDefOK);
  end;

  DestroyInfoBox(InfoBox);

  dispose(BootSect);
  dispose(PartSect);
  dispose(PartCyln);
  WriteTable :=TRUE;
end;

{Eintrag anzeigen}
procedure DisplayEntry(Entry :PPartChain; Pos :integer; HI :boolean);
begin
  if (HI) then
	if (CRTIsMono) then
	  SetColor(MonSelVG, MonSelBG)
	else
	  SetColor(ColSelVG, ColSelBG)
  else if (CRTIsMono )then
	SetColor(MonWinVG, MonWinBG)
  else
	SetColor(ColWinVG, ColWinBG);

  GotoXY(1, Pos + 1);
  ClrEOL;
  if (Entry^.PartEntr <> PartEntrNone) then
	write(Entry^.PartEntr:2, ' ', Entry^.PartName);

  GotoXY(21, Pos + 1);
  if (Entry^.PartDriv < MaxLogDrives) then
	write(chr(66 + Entry^.PartDriv + LogStart), ':');

  if ((Entry^.PartDriv >= PartDrivPri) and (Entry^.PartDriv < PartDrivNone)) then
	write(chr(Entry^.PartDriv - 61), ':');

  GotoXY(25, Pos + 1);

  if (Entry^.PartStat = PartStatLog) then
	write(WIN_PART_NA)
  else if ((Entry^.PartStat =  PartStatPri) or (Entry^.PartStat = PartStatAct)) then
	if (Entry^.PartType in [$11, $14, $16, $17, $1B, $1C, $1E]) then
	  write(WIN_PART_HID)
	else if (Entry^.PartStat = PartStatAct) then
	  write(WIN_PART_ACT)
	else
	  write(WIN_PART_DACT)
  else
	write(WIN_PART_FREE);

  GotoXY(36, Pos + 1);
  case Entry^.PartStat of
	PartStatLog: begin
	  write(WIN_PART_LOG);
	end;

	PartStatUnusable: begin
	  write(WIN_PART_NA);
	end;

	PartStatFreePri: begin
	  write(WIN_PART_PRI);
	end;

	PartStatFreePriLog: begin
	  write(WIN_PART_ANY);
	end;

	PartStatFreeLog: begin
	  write(WIN_PART_LOG);
	end;
  else
	write(WIN_PART_PRI);
  end;

  GotoXY(45, Pos + 1);
  write(round(Entry^.PartSize / 2048):5, 'MB');

  GotoXY(54, Pos + 1);
  if (Entry^.PartSyst <> PartSystNone) then
	write(SPartType[Entry^.PartSyst])
  else if (Entry^.PartStat in [PartStatPri, PartStatAct, PartStatLog]) then
	write(WIN_PART_NA, '(', WIN_PART_TYPE, ' ', Byte2Hex(Entry^.PartType), ')')
  else
	write(WIN_PART_NA);

  GotoXY(68, Pos + 1);
  if (Entry^.PartType in [$01, $04, $06, $07, $0E, $11, $14, $16, $17, $1E]) then
	write(Entry^.PartLabl)
  else
	write(WIN_PART_NA);

  GotoXY(1, Pos + 1);
end;

{Partitionstabelle anzeigen}
procedure DisplayTable(Drive, Offset :byte);
var
  HDriv :PDriveChain;
  WPart :PPartChain;
  PCnt	:integer;
begin
  window(1, 2, 80, 24);
  if (CRTIsMono) then
	SetColor(MonWinVG, MonWinBG)
  else
	SetColor(ColWinVG, ColWinBG);

  GotoXY(3, 1);
  write(' ', WIN_DRIVE_HDR, ' ', Drive - FirstDriveIndex, ' ');

  window(2, 5, 79, 23); ClrScr;
  HDriv :=DriveChain;
  while ((HDriv^.Drive <> Drive) and (HDriv <> nil)) do
	HDriv :=HDriv^.Next;

  WPart :=HDriv^.PartChain; PCnt :=0;
  while ((PCnt < Offset) and (WPart <> nil)) do begin
	WPart :=WPart^.Next;
	inc(PCnt)
  end;

  PCnt :=0;
  while ((PCnt < 19) and (WPart <> nil)) do begin
	DisplayEntry(WPart, PCnt, FALSE);
	WPart :=WPart^.Next;
	inc(PCnt)
  end
end;

{Eintrge in eine Tabelle schreiben und Anzahl zurck}
function GetEntries(Drive :byte; var PTable :TPTable) :integer;
var
  Cnt	:integer;
  HDriv :PDriveChain;
  HPart :PPartChain;
begin
  Cnt :=0;
  HDriv :=DriveChain;
  while (HDriv^.Drive <> Drive) do
	HDriv :=HDriv^.Next;

  HPart :=HDriv^.PartChain;
  while (HPart <> nil) do begin
	PTable[Cnt] :=HPart;
	HPart :=HPart^.Next;
	inc(Cnt);
  end;

  GetEntries :=Cnt
end;

{Partitionstabelle aus dem Speicher lschen}
procedure UnloadTable;
var
  HDrv, WDrv   :PDriveChain;
  HPart, WPart :PPartChain;
begin
  HDrv :=DriveChain;
  while (HDrv <> nil) do begin
	HPart :=HDrv^.PartChain;
	while (HPart <> nil) do begin
	  WPart :=HPart^.Next;
	  dispose(HPart);
	  HPart :=WPart
	end;

	WDrv :=HDrv^.Next;
	dispose(HDrv);
	HDrv :=WDrv
  end
end;
