{
	XTYPES.INC
	Constants and Types
	----------------------------------------------------------------------
	Copyright (c) 1994-98 by Florian Painke (f.painke@gmx.de).

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful, but
	WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to
		Free Software Foundation, Inc.
		59 Temple Place - Suite 330
		Boston, MA  02111-1307, USA
	or visit the GNU Homepage at http://www.gnu.org/.
}

const
  {Men Eckdaten}
  MaxMenuWidth = 40;
  {Maximale Anzahl an primren Partitionen}
  MaxPartitions = 4;
  {Maximale Anzahl an logischen Laufwerken}
  MaxLogDrives	= 24;

type
  {Versionsinformation}
  TVerTag = (ALPHA, BETA, GAMMA, RELEASE);
  TVerInfo = record
	Tag 	 :TVerTag;
	Prog	 :integer;
	Major	 :integer;
	Minor	 :integer;
	Patch	 :integer;
	Build	 :integer;
  end;
  {Chain fr die Partitionen}
  PPartChain = ^TPartChain;
  TPartChain = record
	IsNew	 :boolean;				   {Status der Partition}
	PartPos  :byte; 				   {Position der Partition in der Tabelle}
	PartEntr :byte; 				   {Position der Partition im BootMen}
	PartName :array[0..16] of char;    {Name der Partition}
	PartPWD  :array[0..16] of char;    {Passwort}
	PartDriv :byte; 				   {Logische Laufwerksnummer}
	PartStat :byte; 				   {Status AKT/INAKT/NA/FREI}
	PartSize :longint;				   {Gre der Partition}
	PartType :byte; 				   {Partitionstyp}
	Distance :longint;				   {Entfernung vom Partitiossektor}
	StartPos :TPos; 				   {Startposition der Partition}
	EndPos	 :TPos; 				   {Endposition der Partition}
	PartSyst :integer;				   {Systemkennung}
	PartLabl :array[0..11] of char;    {Label}
	Next	 :PPartChain;
  end;
  {Chain fr die Festplatten}
  PDriveChain = ^TDriveChain;
  TDriveChain = record
	Drive, Head 	  :byte;
	PriPart, _p1, _p2 :byte;
	_l1, _l2		  :byte;
	Cylinder, Sector  :word;
	Size			  :longint;
	MinSize 		  :longint;
	PartChain		  :PPartChain;
	Next			  :PDriveChain;
	ExtPart 		  :boolean;
  end;
  TPTable = array[0..49] of PPartChain;
  {Partitionssektor}
  PSector = ^TSector;
  TSector = record
	Drive, Head 	 :byte;
	Sector, Cylinder :word;
	Buffer			 :TBuffer;
  end;
  {Ausrichtung des Textes in der Inputbox}
  TAlign = (LEFT, RIGHT);
  {Keyboard Umsetzungstabellen}
  PCKeyTbl = ^TCKeyTbl;
  TCKeyTbl = array[1..255] of char;
  TKeyTbl = (KEYBNONE, KEYBGER, EOKEYBTBL);
  {ExitProgram Codes}
  TExit = (SUCCESS, FAILURE);
  TMenuStr = string[MaxMenuWidth];
  {BeepType}
  TBeep = (SINGLE, TRIPLE, SOS);

const
  {Farbkonstanten fr Farbgrafikkarte}
  ColMenVG = black;
  ColMenBG = lightgray;
  ColMenHI = red;
  ColWinVG = white;
  ColWinBG = blue;
  ColSelVG = blue;
  ColSelBG = lightgray;
  {Attributkonstanten fr Monchromgrafikkarten}
  MonMenVG = 0;
  MonMenBG = 7;
  MonMenHI = 14;
  MonWinVG = 7;
  MonWinBG = 0;
  MonSelVG = 0;
  MonSelBG = 7;

  {XFDISK Checksummen Magics}
  XFDCheckOddMask	= $0A6F0F6E;
  XFDCheckEvenMask	= $14AD0C1D;
  CheckUseMaxMem	= 16384;

  {Fehlerzhler}
  MaxErrCount = 3;

  {CursorAttribute}
  CursorIns = $0607;
  CursorOvr = $0407;

  {Pfade}
  XFDISKPath :string[72] = 'XFDISK.EXE';
  XHELPPath  :string[72] = 'XFDISK.XFH';

  {Maximale Anzahl Zeilen}
  MaxLines = 18;

  {Erstes Laufwerk}
  FirstDriveIndex = $7F;
  FirstDrive	  = FirstDriveIndex + 1;

  {Lnge des Partitionscylinders}
  PartCylnSectorCount = 17;

  {Lnge und Position des BootManagers}
  BMSectorStart =  2;
  BMSectorCount = 16;

  {Bootmanager Versionsnummern}
  BMVersionExtension1 = 10005;
  BMVersionExtension2 = 10007;

  {Eintrge in den BootManager}
  MaxEntries = 8;

  {Timeout Default, Minimum und Maximum}
  TimeoutDef = 30;
  TimeoutMin = 5;
  TimeoutMax = 300;

  {Crypt Sizes}
  XCRYSize	 :word	  = $1DB4;
  OldCRYSize :word	  = $1DF0;
  CryptSize  :word	  = $1DB4;
  XCHKSize	 :word	  = $1DB4;
  OldCHKSize :word	  = $1DF4;
  CheckSize  :word	  = $1DB4;

  {BootManager Checksummen Magics}
  BMCheckOddMask  =$12A01F86;
  BMCheckEvenMask =$041A1AE9;

  {Marker $AA55}
  Marker = $AA55;

  {Leerer Bootsektor}
  EmptyBootSect = $F6;

  {Partitionsposition}
  PartPosNone = 255;

  {Partitions-Status}
  PartStatPri		 =	 0;
  PartStatAct		 = 128;
  PartStatLog		 = 255;

  PartStatFree		 = 254;
  PartStatFreePri	 =	16;
  PartStatFreePriLog =	32;
  PartStatFreeLog	 =	64;

  PartStatUnusable	 = 253;

  {Partitions-Laufwerk}
  PartDrivPri  = 128;
  PartDrivNone = 255;

  {Partitions-Eintrag}
  PartEntrNone = 255;

  {Partitions-Typ}
  PartTypeNone = 0;
  PartTypeExt  = 5;

  {Standard Dateisysteme}
  PartTypeFAT12    = $01;
  PartTypeFAT16Sml = $04;
  PartTypeFAT16Big = $06;
  PartTypeFAT32    = $0B;

  {Partitions-Bereiche}
  MaxFAT12Size	  = 32679;
  MaxFAT16SmlSize = 65535;
  MaxFAT16BigSize = 4194303;

  {Partitions-System}
  PartSystNone = 0;

  {Partitions-Maske}
  PartMaskHide = $10;

  {Message Box Buttons}
  ButtonMask		= $0F;
  ButtonOK			= $00;
  ButtonYesNo		= $01;
  ButtonYesNoCancel = $02;

  ButtonDefMask 	= $F0;
  ButtonDefDiv		= $10;
  ButtonDefOK		= $00;
  ButtonDefYes		= $00;
  ButtonDefNo		= $10;
  ButtonDefCancel	= $20;

  ButtonResOK		= $00;
  ButtonResYes		= $00;
  ButtonResNo		= $01;
  ButtonResCancel	= $02;

  {Normale Tastaturcodes}
  KeyCtrlC		=	3;
  KeyBackspace	=	8;
  KeyTab		=	9;
  KeyEnter		=  13;
  KeyEscape 	=  27;
  KeyMinChr 	=  32;
  KeyMaxChr 	= 127;

  {Erweiterte Tastaturcodes}
  KeyExtended	= 256;
  KeyF1 		= 315;
  KeyF3 		= 317;
  KeyHome		= 327;
  KeyArrowUp	= 328;
  KeyPageUp 	= 329;
  KeyArrowLeft	= 331;
  KeyArrowRight = 333;
  KeyEnd		= 335;
  KeyArrowDown	= 336;
  KeyPageDown	= 337;
  KeyInsert 	= 338;
  KeyDelete 	= 339;

  {ASCII Codes}
  ChrBell  = #$07;
  ChrTab   = #$09;
  ChrArrow = #$10;
  ChrSpace = #$20;
  ChrCheck = #$FB;

  {Untersttzte Systeme}
  MaxSystems = 61;
  IPartType: array[1..MaxSystems] of integer =
	($00, $01, $02, $03, $04, $06, $07, $08, $09, $0A,
	 $0B, $0C, $0E, $0F, $10, $11, $12, $14, $16, $17,
	 $18, $1B, $1C, $1E, $24, $3C, $40, $42, $50, $51,
	 $52, $56, $61, $63, $64, $65, $70, $75, $80, $81,
	 $82, $83, $84, $93, $94, $A5, $B7, $B8, $C1, $C4,
	 $C6, $C7, $DB, $E1, $E2, $E4, $F2, $F4, $F5, $FE,
	 $FF);
  SPartType: array[1..MaxSystems] of string[12] =
	('Ungltig    ', 'FAT12 <32M  ', 'XENIX root  ', 'XENIX usr   ', 'FAT16 <32M  ',
	 'FAT16 >32M  ', 'HPFS/NTFS   ', 'AIX Boot    ', 'AIX/Coherent', 'Boot Manager',
	 'FAT32       ', 'FAT32 INT13X', 'FAT16 INT13X', 'WIN95 EXT.  ', 'OPUS        ',
	 'FAT12 <32M  ', 'Compaq Diag ', 'FAT16 <32M  ', 'FAT16 >32M  ', 'HPFS/NTFS   ',
	 'AST Swap    ', 'FAT32       ', 'FAT32 INT13X', 'FAT16 INT13X', 'NEC DOS     ',
	 'Recovery    ', 'VENIX 80286 ', 'SFS         ', 'Disk Manager', 'Disk Manager',
	 'CP/M        ', 'VFeature    ', 'SpeedStor   ', 'System V/386', 'NetWare     ',
	 'NetWare     ', 'Multi-Boot  ', 'PC/IX       ', 'Minix       ', 'Linux Minix ',
	 'Linux Swap  ', 'Linux Native', 'FAT16 <32M  ', 'Amoeba      ', 'Amoeba BBT  ',
	 'BSD/386     ', 'BSDI        ', 'BSDI Swap   ', 'DR DOS FAT12', 'DR DOS FAT16',
	 'DR DOS FAT16', 'Syrinx Boot ', 'CP/M        ', 'SpeedStor 12', 'DOS R/O     ',
	 'SpeedStor 16', 'DOS 2ndary  ', 'SpeedStor   ', 'Prologue    ', 'LANstep     ',
	 'Xenix BBT   ');

  {Passwort Umsetzungstabelle}
  PWDTable1 :array[0..16] of char ='Ui3=kE@#l~}4D$h&';
  PWDTable2 :array[0..16] of char ='4E)\De<-5l?Q$1Wi';

  IGERKeyTblCnt = 96;
  IKeyTblCnt :array[TKeyTbl] of integer =
	(0, IGERKeyTblCnt, 0);
  SKeyTblTag :array[TKeyTbl] of string =
	('NONE', 'GER', '');

  {Keyboard Umsetzungstabelle Ger to US}
  CGERKeyTblSrc: array[1..IGerKeyTblCnt] of char =
	('^', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '', '''',
	 'q', 'w', 'e', 'r', 't', 'z', 'u', 'i', 'o', 'p', '', '+',
	 'a', 's', 'd', 'f', 'g', 'h', 'j', 'k', 'l', '', '', '#',
	 '<', 'y', 'x', 'c', 'v', 'b', 'n', 'm', ',', '.', '-',
	 '', '!', '"', '', '$', '%', '&', '/', '(', ')', '=', '?', '`',
	 'Q', 'W', 'E', 'R', 'T', 'Z', 'U', 'I', 'O', 'P', '', '*',
	 'A', 'S', 'D', 'F', 'G', 'H', 'J', 'K', 'L', '', '', '''',
	 '>', 'Y', 'X', 'C', 'V', 'B', 'N', 'M' ,';', ':', '_');
  CGERKeyTblDest: array[1..IGerKeyTblCnt] of char =
	('`', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '-', '|',
	 'q', 'w', 'e', 'r', 't', 'y', 'u', 'i', 'o', 'p', '[', ']',
	 'a', 's', 'd', 'f', 'g', 'h', 'j', 'k', 'l', ';', '''', '\',
	 '\', 'z', 'x', 'c', 'v', 'b', 'n', 'm', ',', '.', '/',
	 '~', '!', '@', '#', '$', '%', '^', '&', '*', '(', ')', '_', '+',
	 'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I', 'O', 'P', '{', '}',
	 'A', 'S', 'D', 'F', 'G', 'H', 'J', 'K', 'L', ':', '"', '|',
	 '|', 'Z', 'X', 'C', 'V', 'B', 'N', 'M', '<', '>', '?');

  {Hilfe-spezifische Konstanten}
  {Endkey Tag}
  CHelpEndKey = '[ENDKEY]';

  {Maximale Zeilen in der Hilfe}
  MaxHelpLines = 18;
